/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.browser;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.xmind.core.command.Command;
import org.xmind.core.command.CommandJob;
import org.xmind.core.command.ICommand;
import org.xmind.ui.browser.IBrowser;
import org.xmind.ui.internal.browser.BrowserEditorInput;
import org.xmind.ui.internal.browser.BrowserMessages;
import org.xmind.ui.internal.browser.BrowserSupportImpl;
import org.xmind.ui.internal.browser.BrowserUtil;
import org.xmind.ui.internal.browser.InternalBrowserEditor;
import org.xmind.ui.internal.browser.InternalBrowserView;

public class InternalBrowser
implements IBrowser {
    private BrowserSupportImpl support;
    private String clientId;
    private Object windowKey = null;
    private boolean asEditor;
    private int browserStyle;
    private String name;
    private String tooltip;
    private IWorkbenchPart part;
    private IPartListener listener;
    private IWebBrowser workbenchBrowser;

    public InternalBrowser(BrowserSupportImpl support, String clientId, boolean asEditor, int style) {
        this.support = support;
        this.clientId = clientId;
        this.asEditor = asEditor;
        this.browserStyle = style;
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void openURL(String url) throws PartInitException {
        Command command = Command.parseURI((String)url);
        if (command != null) {
            new CommandJob((ICommand)command, null).schedule();
            return;
        }
        url = BrowserUtil.normalizeURL(url);
        try {
            this.doOpenURL(url);
        }
        catch (PartInitException partInitException) {
            this.doOpenURLByWorkbenchBrowser(url);
        }
    }

    protected void doOpenURL(String url) throws PartInitException {
        IWorkbenchPage page;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = page = window == null ? null : window.getActivePage();
        if (page == null) {
            throw new PartInitException(BrowserMessages.InternalWebBrowser_ErrorCouldNotLaunchWebBrowser_message);
        }
        if (this.part instanceof IEditorPart) {
            ((IEditorPart)this.part).init(((IEditorPart)this.part).getEditorSite(), (IEditorInput)this.createEditorInput(url));
            page.activate(this.part);
        } else {
            if (this.asEditor) {
                this.part = page.openEditor((IEditorInput)this.createEditorInput(url), "org.xmind.ui.browser.editor");
            } else {
                this.part = page.showView("org.xmind.ui.BrowserView", this.clientId, 1);
                if (this.part instanceof InternalBrowserView) {
                    ((InternalBrowserView)this.part).changeStyle(this.browserStyle);
                    ((InternalBrowserView)this.part).openURL(url);
                }
            }
            this.hookPart(page, this.part);
        }
    }

    private BrowserEditorInput createEditorInput(String url) {
        BrowserEditorInput input = new BrowserEditorInput(url, this.clientId, this.browserStyle);
        input.setName(this.name);
        input.setToolTipText(this.tooltip);
        return input;
    }

    private void hookPart(final IWorkbenchPage page, IWorkbenchPart editorPart) {
        this.listener = new IPartListener(){

            public void partActivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
                if (part.equals(InternalBrowser.this.part)) {
                    InternalBrowser.this.part = null;
                    page.removePartListener(InternalBrowser.this.listener);
                    InternalBrowser.this.support.removeInternalBrowser(InternalBrowser.this);
                }
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partOpened(IWorkbenchPart part) {
            }
        };
        page.addPartListener(this.listener);
    }

    protected void doOpenURLByWorkbenchBrowser(String url) throws PartInitException {
        try {
            URL theURL = new URL(url);
            this.getWorkbenchBrowser().openURL(theURL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new PartInitException(BrowserMessages.InternalWebBrowser_ErrorCouldNotLaunchWebBrowser_message);
        }
    }

    private IWebBrowser getWorkbenchBrowser() throws PartInitException {
        if (this.workbenchBrowser == null) {
            this.workbenchBrowser = this.createWorkbenchBrowser();
        }
        return this.workbenchBrowser;
    }

    protected IWebBrowser createWorkbenchBrowser() throws PartInitException {
        return PlatformUI.getWorkbench().getBrowserSupport().createBrowser(38, this.getClientId(), this.name, this.tooltip);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Object getWindowKey() {
        if (this.windowKey == null) {
            this.windowKey = this.createWindowKey();
        }
        return this.windowKey;
    }

    private Object createWindowKey() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return this;
        }
        return BrowserUtil.getWindowKey(window);
    }

    public void close() {
        if (this.part != null) {
            if (this.part instanceof IEditorPart) {
                this.part.getSite().getPage().closeEditor((IEditorPart)this.part, false);
            } else {
                this.part.getSite().getPage().hideView((IViewPart)this.part);
            }
        }
        if (this.workbenchBrowser != null) {
            this.workbenchBrowser.close();
        }
    }

    public void setText(String text) throws PartInitException {
        this.doOpenURL(null);
        if (this.part != null && this.part instanceof InternalBrowserEditor) {
            ((InternalBrowserEditor)this.part).setText(text);
        }
    }
}

