/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.decorations;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITitledFigure;
import org.xmind.gef.draw2d.decoration.IShadowedDecoration;
import org.xmind.gef.draw2d.decoration.PathConnectionDecoration;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.ui.decorations.IArrowDecoration;
import org.xmind.ui.decorations.IRelationshipDecoration;

public abstract class AbstractRelationshipDecoration
extends PathConnectionDecoration
implements IRelationshipDecoration,
IShadowedDecoration {
    private static final Rectangle CLIP = new Rectangle();
    protected Double sourceCPAngle = null;
    protected Double sourceCPAmount = null;
    protected Double targetCPAngle = null;
    protected Double targetCPAmount = null;
    protected Point relativeSourceCP = null;
    protected Point relativeTargetCP = null;
    private PrecisionPoint sourceCP = null;
    private PrecisionPoint targetCP = null;
    private IArrowDecoration arrow1 = null;
    private IArrowDecoration arrow2 = null;
    private PrecisionPoint titlePos = null;

    protected AbstractRelationshipDecoration() {
    }

    protected AbstractRelationshipDecoration(String id) {
        super(id);
    }

    protected int getLineWidthForChecking() {
        return super.getLineWidthForChecking() * 3 + 10;
    }

    public void reroute(IFigure figure) {
        super.reroute(figure);
        this.updateArrows(figure);
    }

    protected void reroute(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos, boolean validating) {
        PrecisionPoint oldSourceCP = this.sourceCP;
        PrecisionPoint oldTargetCP = this.targetCP;
        PrecisionPoint oldTitlePos = this.titlePos;
        PrecisionPoint newSourceCP = new PrecisionPoint();
        PrecisionPoint newTargetCP = new PrecisionPoint();
        PrecisionPoint newTitlePos = new PrecisionPoint();
        this.reroute(figure, sourcePos, targetPos, newSourceCP, newTargetCP);
        this.calcTitlePosition(figure, newTitlePos, sourcePos, targetPos, newSourceCP, newTargetCP);
        this.sourceCP = newSourceCP;
        this.targetCP = newTargetCP;
        this.titlePos = newTitlePos;
        if (!(validating || figure == null || newSourceCP.equals((Object)oldSourceCP) && newTargetCP.equals((Object)oldTargetCP) && newTitlePos.equals((Object)oldTitlePos))) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    protected void reroute(IFigure figure, PrecisionPoint sourcePos, PrecisionPoint targetPos, PrecisionPoint sourceCP, PrecisionPoint targetCP) {
        IAnchor sa = this.getSourceAnchor();
        IAnchor ta = this.getTargetAnchor();
        PrecisionPoint a1 = null;
        PrecisionPoint a2 = null;
        if (sa != null) {
            if (this.relativeSourceCP != null) {
                sourceCP.setLocation(sa.getReferencePoint()).translate((double)this.relativeSourceCP.x, (double)this.relativeSourceCP.y);
                sourcePos.setLocation(sa.getLocation(sourceCP, 0.0));
            } else if (ta != null) {
                if (a1 == null) {
                    a1 = sa.getLocation(ta.getReferencePoint(), 0.0);
                }
                sourcePos.setLocation(a1);
                if (a2 == null) {
                    a2 = ta.getLocation(sa.getReferencePoint(), 0.0);
                }
                sourceCP.setLocation(a1).move(a2, 0.4);
            }
        }
        if (ta != null) {
            if (this.relativeTargetCP != null) {
                targetCP.setLocation(ta.getReferencePoint()).translate((double)this.relativeTargetCP.x, (double)this.relativeTargetCP.y);
                targetPos.setLocation(ta.getLocation(targetCP, 0.0));
            } else if (sa != null) {
                if (a2 == null) {
                    a2 = ta.getLocation(sa.getReferencePoint(), 0.0);
                }
                targetPos.setLocation(a2);
                if (a1 == null) {
                    a1 = sa.getLocation(ta.getReferencePoint(), 0.0);
                }
                targetCP.setLocation(a2).move(a1, 0.4);
            }
        }
    }

    protected void updatePosAndCp(IAnchor anchor, PrecisionPoint pos, PrecisionPoint cp, double angle) {
        Point center = anchor.getReferencePoint().toDraw2DPoint();
        Point rotatedCp = Geometry.getRotatedPoint((Point)new Point(cp.toDraw2DPoint()).translate(-center.x, -center.y), (double)angle);
        cp.setLocation(rotatedCp.translate(center.x, center.y));
        pos.setLocation(anchor.getLocation(cp, 0.0));
    }

    protected void calcTitlePosition(IFigure figure, PrecisionPoint titlePos, PrecisionPoint sourcePos, PrecisionPoint targetPos, PrecisionPoint sourceCP, PrecisionPoint targetCP) {
        titlePos.setLocation((sourcePos.x + targetPos.x) / 2.0, (sourcePos.y + targetPos.y) / 2.0);
    }

    protected boolean isPositionValid() {
        return super.isPositionValid() && this.sourceCP != null && this.targetCP != null && this.titlePos != null;
    }

    @Override
    public PrecisionPoint getSourceControlPoint(IFigure figure) {
        this.checkValidation(figure);
        return this.sourceCP;
    }

    @Override
    public PrecisionPoint getTargetControlPoint(IFigure figure) {
        this.checkValidation(figure);
        return this.targetCP;
    }

    @Override
    public void setRelativeSourceControlPoint(IFigure figure, Point point) {
        if (point == this.relativeSourceCP || point != null && point.equals((Object)this.relativeSourceCP)) {
            return;
        }
        this.relativeSourceCP = point;
        if (figure != null) {
            figure.revalidate();
            figure.repaint();
        }
        this.invalidate();
    }

    @Override
    public void setRelativeTargetControlPoint(IFigure figure, Point point) {
        if (point == this.relativeTargetCP || point != null && point.equals((Object)this.relativeTargetCP)) {
            return;
        }
        this.relativeTargetCP = point;
        if (figure != null) {
            figure.revalidate();
            figure.repaint();
        }
        this.invalidate();
    }

    @Override
    public void setSourceControlPointHint(IFigure figure, Double angle, Double amount) {
        boolean changed = false;
        if (!(angle == this.sourceCPAngle || angle != null && angle.equals(this.sourceCPAngle))) {
            changed = true;
            this.sourceCPAngle = angle;
        }
        if (!(amount == this.sourceCPAmount || amount != null && amount.equals(this.sourceCPAmount))) {
            changed = true;
            this.sourceCPAmount = amount;
        }
        if (changed && figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    @Override
    public void setTargetControlPointHint(IFigure figure, Double angle, Double amount) {
        boolean changed = false;
        if (!(angle == this.targetCPAngle || angle != null && angle.equals(this.targetCPAngle))) {
            changed = true;
            this.targetCPAngle = angle;
        }
        if (!(amount == this.targetCPAmount || amount != null && amount.equals(this.targetCPAmount))) {
            changed = true;
            this.targetCPAmount = amount;
        }
        if (changed && figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    protected double getSourceAnchorAngle(IFigure figure) {
        PrecisionPoint p1 = this.getSourcePosition(figure);
        PrecisionPoint p2 = this.getSourceControlPoint(figure);
        return Geometry.getAngle((PrecisionPoint)p2, (PrecisionPoint)p1);
    }

    protected double getTargetAnchorAngle(IFigure figure) {
        PrecisionPoint p1 = this.getTargetPosition(figure);
        PrecisionPoint p2 = this.getTargetControlPoint(figure);
        return Geometry.getAngle((PrecisionPoint)p2, (PrecisionPoint)p1);
    }

    @Override
    public IArrowDecoration getArrow1() {
        return this.arrow1;
    }

    @Override
    public IArrowDecoration getArrow2() {
        return this.arrow2;
    }

    @Override
    public void setArrow1(IFigure figure, IArrowDecoration arrow) {
        if (arrow == this.arrow1) {
            return;
        }
        this.arrow1 = arrow;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    @Override
    public void setArrow2(IFigure figure, IArrowDecoration arrow) {
        if (arrow == this.arrow2) {
            return;
        }
        this.arrow2 = arrow;
        if (figure != null) {
            figure.revalidate();
            this.repaint(figure);
        }
    }

    public void invalidate() {
        if (this.arrow1 != null) {
            this.arrow1.invalidate();
        }
        if (this.arrow2 != null) {
            this.arrow2.invalidate();
        }
        super.invalidate();
    }

    public void validate(IFigure figure) {
        super.validate(figure);
        if (this.arrow1 != null) {
            this.arrow1.validate(figure);
        }
        if (this.arrow2 != null) {
            this.arrow2.validate(figure);
        }
    }

    public void paint(IFigure figure, Graphics graphics) {
        super.paint(figure, graphics);
        if (this.arrow1 != null) {
            this.arrow1.paint(figure, graphics);
        }
        if (this.arrow2 != null) {
            this.arrow2.paint(figure, graphics);
        }
    }

    public Rectangle getPreferredBounds(IFigure figure) {
        Rectangle r = super.getPreferredBounds(figure);
        if (this.arrow1 != null) {
            r = r.getUnion(this.arrow1.getPreferredBounds(figure));
        }
        if (this.arrow2 != null) {
            r = r.getUnion(this.arrow2.getPreferredBounds(figure));
        }
        return r;
    }

    @Override
    public PrecisionPoint getTitlePosition(IFigure figure) {
        this.checkValidation(figure);
        return this.titlePos;
    }

    private void updateArrows(IFigure figure) {
        if (this.arrow1 != null) {
            this.arrow1.setPosition(figure, this.getSourcePosition(figure));
            this.arrow1.setAngle(figure, this.getSourceAnchorAngle(figure));
            this.arrow1.reshape(figure);
        }
        if (this.arrow2 != null) {
            this.arrow2.setPosition(figure, this.getTargetPosition(figure));
            this.arrow2.setAngle(figure, this.getTargetAnchorAngle(figure));
            this.arrow2.reshape(figure);
        }
    }

    public void paintShadow(IFigure figure, Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        this.checkValidation(figure);
        graphics.setAlpha(this.getAlpha());
        graphics.setForegroundColor(ColorConstants.black);
        graphics.setLineWidth(this.getLineWidth());
        graphics.setLineStyle(this.getLineStyle());
        this.drawLine(figure, graphics);
    }

    protected void paintPath(IFigure figure, Graphics graphics, Path path, boolean fill) {
        ITextFigure tf = this.getTitleFigure(figure);
        if (tf != null && tf.isShowing()) {
            Rectangle bounds = figure.getBounds();
            Rectangle titleArea = tf.getBounds();
            if (titleArea.intersects(bounds)) {
                graphics.pushState();
                try {
                    this.paintPathAroundTitle(figure, graphics, path, fill, bounds, titleArea);
                }
                finally {
                    graphics.popState();
                }
                return;
            }
        }
        super.paintPath(figure, graphics, path, fill);
    }

    private void paintPathAroundTitle(IFigure figure, Graphics graphics, Path path, boolean fill, Rectangle bounds, Rectangle titleArea) {
        int w = bounds.width;
        int h = titleArea.y - bounds.y;
        if (w > 0 && h > 0) {
            CLIP.setSize(w, h);
            CLIP.setLocation(bounds.x, bounds.y);
            this.paintPathWithClip(figure, graphics, path, fill, CLIP);
        }
        w = bounds.width;
        h = bounds.y + bounds.height - titleArea.y - titleArea.height;
        if (w > 0 && h > 0) {
            CLIP.setSize(w, h);
            CLIP.setLocation(bounds.x, titleArea.y + titleArea.height);
            this.paintPathWithClip(figure, graphics, path, fill, CLIP);
        }
        w = titleArea.x - bounds.x;
        h = titleArea.height;
        if (w > 0 && h > 0) {
            CLIP.setSize(w, h);
            CLIP.setLocation(bounds.x, titleArea.y);
            this.paintPathWithClip(figure, graphics, path, fill, CLIP);
        }
        if ((w = bounds.x + bounds.width - titleArea.x - titleArea.width) > 0 && h > 0) {
            CLIP.setSize(w, h);
            CLIP.setLocation(titleArea.x + titleArea.width, titleArea.y);
            this.paintPathWithClip(figure, graphics, path, fill, CLIP);
        }
        CLIP.setBounds(titleArea);
        int alpha = graphics.getAlpha();
        graphics.setAlpha((int)((double)alpha * 0.1));
        this.paintPathWithClip(figure, graphics, path, fill, CLIP);
    }

    protected void paintPathWithClip(IFigure figure, Graphics graphics, Path path, boolean fill, Rectangle clip) {
        graphics.setClip(clip);
        super.paintPath(figure, graphics, path, fill);
        graphics.restoreState();
    }

    protected ITextFigure getTitleFigure(IFigure figure) {
        if (figure instanceof ITitledFigure) {
            return ((ITitledFigure)figure).getTitle();
        }
        return null;
    }
}

