/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xmind.ui.internal.CategoryManager;
import org.xmind.ui.mindmap.ICategoryAnalyzation;

public class CategoryAnalyzation
implements ICategoryAnalyzation {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Object[] elements;
    private CategoryManager manager;
    private Map<String, List<Object>> map = null;
    private String mainCategory = null;

    CategoryAnalyzation(Object[] elements, CategoryManager manager) {
        this.elements = elements;
        this.manager = manager;
    }

    @Override
    public Object[] getElements() {
        return this.elements;
    }

    @Override
    public boolean isEmpty() {
        return "no category".equals(this.getMainCategory());
    }

    @Override
    public String getMainCategory() {
        this.checkAnalyze();
        return this.mainCategory;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    private void checkAnalyze() {
        if (this.mainCategory == null || this.map == null) {
            this.analyze();
        }
    }

    private void analyze() {
        String[] categories = this.manager.getAllCategories();
        Object[] objectArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            List<Object> list;
            Object o = objectArray[n2];
            String t = this.getCategory(o, categories);
            if (t == null) {
                t = "unknown category";
            }
            if (this.mainCategory == null) {
                this.mainCategory = t;
            } else if (!"multiple categories".equals(this.mainCategory) && !this.mainCategory.equals(t)) {
                this.mainCategory = "multiple categories";
            }
            if (this.map == null) {
                this.map = new HashMap<String, List<Object>>();
            }
            if ((list = this.map.get(t)) == null) {
                list = new ArrayList<Object>();
                this.map.put(t, list);
            }
            list.add(o);
            ++n2;
        }
        if (this.mainCategory == null) {
            this.mainCategory = "no category";
        }
        if (this.map == null) {
            this.map = Collections.emptyMap();
        }
    }

    private String getCategory(Object o, String[] categories) {
        String[] stringArray = categories;
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            String category = stringArray[n2];
            if (this.manager.belongsToCategory(o, category)) {
                return category;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String[] getMultipleCategories() {
        this.checkAnalyze();
        Set<String> categories = this.map.keySet();
        return categories.toArray(new String[categories.size()]);
    }

    @Override
    public Object[] getElementsByCategory(String type) {
        this.checkAnalyze();
        List<Object> list = this.map.get(type);
        if (list == null) {
            return EMPTY_ARRAY;
        }
        return list.toArray();
    }

    @Override
    public int getNumElementsByCategory(String type) {
        this.checkAnalyze();
        List<Object> list = this.map.get(type);
        return list == null ? 0 : list.size();
    }

    @Override
    public boolean isMultiple() {
        return "multiple categories".equals(this.getMainCategory());
    }
}

