/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.graphicalpolicy.IStyleSelector;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.IBranchHook;
import org.xmind.ui.branch.IBranchPolicyAdvisor;
import org.xmind.ui.branch.IBranchPolicyDescriptor;
import org.xmind.ui.branch.IBranchPropertyTester;
import org.xmind.ui.internal.branch.AbstractBranchPolicy;
import org.xmind.ui.internal.branch.AdditionalStructure;
import org.xmind.ui.internal.branch.BranchHookFactory;
import org.xmind.ui.internal.branch.BranchPolicyManager;
import org.xmind.ui.internal.branch.ContributedBranchStyleSelector;
import org.xmind.ui.internal.branch.IStructureDescriptor;
import org.xmind.ui.internal.branch.UnmodifiableProperty;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.ICacheManager;
import org.xmind.ui.util.Logger;
import org.xmind.ui.util.MindMapUtils;

class BranchPolicy
extends AbstractBranchPolicy
implements IBranchPolicyDescriptor {
    private static final String SHOULD_NOTIFY_POST_DEACTIVATE = "org.xmind.ui.branch.internal.shouldNotifyPostDeactivate";
    private IConfigurationElement element;
    private ImageDescriptor icon;
    private Expression enablementCondition;
    private Expression overrideCondition;
    private String defaultStructureId;
    private IStructureDescriptor defaultStructure;
    private List<AdditionalStructure> additionalStructures;
    private IBranchPropertyTester propertyTester;
    private boolean triedLoadingPropertyTester;
    private BranchHookFactory branchHookFactory;
    private boolean triedLoadingBranchHook;
    private Set<String> structureCacheKeys;
    private Map<String, Map<String, List<UnmodifiableProperty>>> unmodifiableProperties;
    private IBranchPolicyAdvisor advisor;
    private boolean triedLoadingAdvisor;
    private Expression advisorCondition;

    public BranchPolicy(BranchPolicyManager manager, IConfigurationElement element) throws CoreException {
        super(manager, element.getAttribute("id"));
        this.element = element;
        this.load();
    }

    private void load() throws CoreException {
        this.defaultStructureId = this.element.getAttribute("defaultStructureId");
        if (this.defaultStructureId == null) {
            throw new CoreException((IStatus)new Status(4, this.element.getNamespaceIdentifier(), 0, "Invalid extension (missing default structure id): " + this.getId(), null));
        }
        this.initializeEnablement();
        this.initializeOverride();
    }

    private void initializeEnablement() {
        IConfigurationElement[] elements = this.element.getChildren("enablement");
        if (elements.length == 0) {
            return;
        }
        try {
            this.enablementCondition = ExpressionConverter.getDefault().perform(elements[0]);
        }
        catch (CoreException e) {
            Logger.log(e, "Unable to convert enablement expression:" + this.getId());
        }
    }

    private void initializeOverride() {
        IConfigurationElement[] overrideElements = this.element.getChildren("override");
        if (overrideElements.length == 0) {
            return;
        }
        IConfigurationElement[] elements = overrideElements[0].getChildren("enablement");
        if (elements.length == 0) {
            return;
        }
        try {
            this.overrideCondition = ExpressionConverter.getDefault().perform(elements[0]);
        }
        catch (CoreException e) {
            Logger.log(e, "Unable to convert override expression:" + this.getId());
        }
    }

    @Override
    public String getId() {
        return this.getPolicyId();
    }

    @Override
    public ImageDescriptor getIcon() {
        if (this.icon == null) {
            this.icon = this.createIcon();
        }
        return this.icon;
    }

    private ImageDescriptor createIcon() {
        String iconName = this.element.getAttribute("icon");
        if (iconName != null) {
            String plugId = this.element.getNamespaceIdentifier();
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)plugId, (String)iconName);
        }
        return null;
    }

    @Override
    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    @Override
    public String getCategoryId() {
        return this.element.getAttribute("categoryId");
    }

    @Override
    public String getName(IBranchPart branch) {
        return this.getName();
    }

    @Override
    public ImageDescriptor getIcon(IBranchPart branch) {
        return this.getIcon();
    }

    public boolean isApplicableTo(IBranchPart branch) {
        if (this.enablementCondition == null) {
            return true;
        }
        return this.isApplicableTo(BranchPolicyManager.createBranchEvaluationContext(branch));
    }

    boolean isApplicableTo(IEvaluationContext context) {
        if (this.enablementCondition == null) {
            return true;
        }
        try {
            EvaluationResult result = this.enablementCondition.evaluate(context);
            return result == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            Logger.log(e, "Evaluation failed on: " + this.getId());
            return false;
        }
    }

    boolean canOverride(IEvaluationContext context) {
        if (this.overrideCondition == null) {
            return false;
        }
        try {
            EvaluationResult result = this.overrideCondition.evaluate(context);
            return result == EvaluationResult.TRUE;
        }
        catch (CoreException e) {
            Logger.log(e, "Evaluation failed on: " + this.getId());
            return false;
        }
    }

    private IStructureDescriptor getDefaultStructure() {
        if (this.defaultStructure == null) {
            this.defaultStructure = this.manager.getStructureDescriptor(this.defaultStructureId);
        }
        return this.defaultStructure;
    }

    @Override
    public String getDefaultStructureId() {
        return this.defaultStructureId;
    }

    private List<AdditionalStructure> getAdditionalStructures() {
        if (this.additionalStructures == null) {
            this.loadAdditionalStructures();
            if (this.additionalStructures == null) {
                this.additionalStructures = Collections.emptyList();
            }
        }
        return this.additionalStructures;
    }

    private void loadAdditionalStructures() {
        IConfigurationElement[] children = this.element.getChildren("additionalStructures");
        if (children.length == 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = children = children[0].getChildren("additionalStructure");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.readAdditionalStructure(child);
            ++n2;
        }
    }

    private void readAdditionalStructure(IConfigurationElement element) {
        try {
            AdditionalStructure additionalStructure = new AdditionalStructure(this.manager, element);
            this.registerAdditionStructure(additionalStructure);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load additional structure: " + element);
        }
    }

    private void registerAdditionStructure(AdditionalStructure additionalStructure) {
        if (this.additionalStructures == null) {
            this.additionalStructures = new ArrayList<AdditionalStructure>();
        }
        this.additionalStructures.add(additionalStructure);
    }

    private BranchHookFactory getBranchHookFactory() {
        if (this.branchHookFactory == null && !this.triedLoadingBranchHook) {
            this.loadBranchHookFactories();
            this.triedLoadingBranchHook = true;
        }
        return this.branchHookFactory;
    }

    private void loadBranchHookFactories() {
        IConfigurationElement[] children = this.element.getChildren("branchHook");
        if (children.length == 0) {
            return;
        }
        this.readBranchHookFactory(children[0]);
    }

    private void readBranchHookFactory(IConfigurationElement element) {
        try {
            this.branchHookFactory = new BranchHookFactory(element);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load branch hook: " + element);
        }
    }

    @Override
    protected void activateBranch(IBranchPart branch) {
        IBranchPolicyAdvisor advisor;
        super.activateBranch(branch);
        ICacheManager cm = MindMapUtils.getCacheManager((IPart)branch);
        if (cm != null) {
            cm.setValueProvider("org.xmind.ui.branchCache.propertyTester", this);
            cm.flush("org.xmind.ui.branchCache.propertyTester");
        }
        if (this.shouldNotifyAdvisor(branch) && (advisor = this.getAdvisor()) != null) {
            advisor.postActivate(branch, this);
        }
    }

    @Override
    protected void deactivateBranch(IBranchPart branch) {
        boolean shouldNotifyAdvisor = this.shouldNotifyAdvisor(branch);
        ICacheManager cm = MindMapUtils.getCacheManager((IPart)branch);
        if (cm != null) {
            cm.flush("org.xmind.ui.branchCache.propertyTester");
            cm.removeValueProvider("org.xmind.ui.branchCache.propertyTester");
        }
        super.deactivateBranch(branch);
        if (cm != null) {
            cm.setCache(SHOULD_NOTIFY_POST_DEACTIVATE, shouldNotifyAdvisor);
        }
    }

    private boolean shouldNotifyAdvisor(IBranchPart branch) {
        if (this.getAdvisor() != null) {
            if (this.advisorCondition != null) {
                IEvaluationContext context = BranchPolicyManager.createBranchEvaluationContext(branch);
                try {
                    return this.advisorCondition.evaluate(context) == EvaluationResult.TRUE;
                }
                catch (CoreException coreException) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected IBranchHook createHook(IBranchPart branch) {
        BranchHookFactory factory = this.getBranchHookFactory();
        if (factory != null) {
            return factory.createHook(branch);
        }
        return null;
    }

    @Override
    public void postDeactivate(IBranchPart branch) {
        IBranchPolicyAdvisor deactivator;
        super.postDeactivate(branch);
        Object shouldUsePostDeactivator = MindMapUtils.getCache((IPart)branch, SHOULD_NOTIFY_POST_DEACTIVATE);
        if (shouldUsePostDeactivator instanceof Boolean && ((Boolean)shouldUsePostDeactivator).booleanValue() && (deactivator = this.getAdvisor()) != null) {
            deactivator.postDeactivate(branch, this);
        }
        MindMapUtils.flushCache((IPart)branch, SHOULD_NOTIFY_POST_DEACTIVATE);
    }

    @Override
    protected void flushStructureCache(IBranchPart branch) {
        super.flushStructureCache(branch);
        for (String cacheKey : this.getStructureCacheKeys()) {
            MindMapUtils.flushCache((IPart)branch, cacheKey);
        }
    }

    private Set<String> getStructureCacheKeys() {
        if (this.structureCacheKeys == null) {
            IConfigurationElement[] children = this.element.getChildren("structureCaches");
            if (children.length > 0 && (children = children[0].getChildren("structureCache")).length > 0) {
                IConfigurationElement[] iConfigurationElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement child = iConfigurationElementArray[n2];
                    this.readStructureCache(child);
                    ++n2;
                }
            }
            if (this.structureCacheKeys == null) {
                this.structureCacheKeys = Collections.emptySet();
            }
        }
        return this.structureCacheKeys;
    }

    private void readStructureCache(IConfigurationElement element) {
        String key = element.getAttribute("key");
        if (key != null) {
            if (this.structureCacheKeys == null) {
                this.structureCacheKeys = new HashSet<String>();
            }
            this.structureCacheKeys.add(key);
        }
    }

    private IBranchPropertyTester getPropertyTester() {
        if (this.propertyTester == null && !this.triedLoadingPropertyTester) {
            String propertyTesterId = this.element.getAttribute("propertyTesterId");
            if (propertyTesterId != null) {
                this.propertyTester = this.manager.getPropertyTester(propertyTesterId);
            }
            this.triedLoadingPropertyTester = true;
        }
        return this.propertyTester;
    }

    protected IStructure createDefaultStructureAlgorithm() {
        return this.getDefaultStructure().getAlgorithm();
    }

    @Override
    protected IStyleSelector createDefaultStyleSelector() {
        IConfigurationElement[] children = this.element.getChildren("styleSelector");
        if (children.length > 0) {
            return new ContributedBranchStyleSelector(this.manager, children[0]);
        }
        return super.createDefaultStyleSelector();
    }

    @Override
    protected boolean isUnmodifiableProperty(IBranchPart branch, String primaryKey, String secondaryKey) {
        Map<String, List<UnmodifiableProperty>> map;
        Map<String, Map<String, List<UnmodifiableProperty>>> unmoProps = this.getUnmodifiableProperties();
        if (!unmoProps.isEmpty() && (map = unmoProps.get(primaryKey)) != null) {
            List<UnmodifiableProperty> list;
            if (secondaryKey == null) {
                secondaryKey = "$NULL$";
            }
            if ((list = map.get(secondaryKey)) != null) {
                IEvaluationContext context = BranchPolicyManager.createBranchEvaluationContext(branch);
                for (UnmodifiableProperty unmoProp : list) {
                    if (!unmoProp.isApplicableTo(context)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Map<String, Map<String, List<UnmodifiableProperty>>> getUnmodifiableProperties() {
        if (this.unmodifiableProperties == null) {
            this.readUnmodifiableProperties();
            if (this.unmodifiableProperties == null) {
                this.unmodifiableProperties = Collections.emptyMap();
            }
        }
        return this.unmodifiableProperties;
    }

    private void readUnmodifiableProperties() {
        IConfigurationElement[] children = this.element.getChildren("unmodifiableProperties");
        if (children.length == 0) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = children = children[0].getChildren("unmodifiableProperty");
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            this.loadUnmodifiableProperty(child);
            ++n2;
        }
    }

    private void loadUnmodifiableProperty(IConfigurationElement element) {
        try {
            UnmodifiableProperty unmodifiableProperty = new UnmodifiableProperty(element);
            this.registerUnmodifiableProperty(unmodifiableProperty);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load unmodifiable property: " + element);
        }
    }

    private void registerUnmodifiableProperty(UnmodifiableProperty unmodifiableProperty) {
        List<UnmodifiableProperty> list;
        Map<String, List<UnmodifiableProperty>> map;
        String primaryKey = unmodifiableProperty.getPrimaryKey();
        String secondaryKey = unmodifiableProperty.getSecondaryKey();
        if (secondaryKey == null) {
            secondaryKey = "$NULL$";
        }
        if (this.unmodifiableProperties == null) {
            this.unmodifiableProperties = new HashMap<String, Map<String, List<UnmodifiableProperty>>>();
        }
        if ((map = this.unmodifiableProperties.get(primaryKey)) == null) {
            map = new HashMap<String, List<UnmodifiableProperty>>();
            this.unmodifiableProperties.put(primaryKey, map);
        }
        if ((list = map.get(secondaryKey)) == null) {
            list = new ArrayList<UnmodifiableProperty>();
            map.put(secondaryKey, list);
        }
        list.add(unmodifiableProperty);
    }

    @Override
    public Object getValue(IPart part, String key) {
        if ("org.xmind.ui.branchCache.propertyTester".equals(key)) {
            return this.getPropertyTester();
        }
        return super.getValue(part, key);
    }

    @Override
    protected String calcAdditionalStructureId(IBranchPart branch, IBranchPart parent) {
        List<AdditionalStructure> additionalStructures = this.getAdditionalStructures();
        if (!additionalStructures.isEmpty()) {
            IEvaluationContext context = BranchPolicyManager.createBranchEvaluationContext(branch);
            for (AdditionalStructure additionalStructure : additionalStructures) {
                if (!additionalStructure.isApplicableTo(context)) continue;
                return additionalStructure.getStructureId();
            }
        }
        return null;
    }

    private IBranchPolicyAdvisor getAdvisor() {
        if (this.advisor == null && !this.triedLoadingAdvisor) {
            IConfigurationElement advisorElement;
            String att;
            this.triedLoadingAdvisor = true;
            IConfigurationElement[] children = this.element.getChildren("advisor");
            if (children.length > 0 && (att = (advisorElement = children[0]).getAttribute("class")) != null) {
                try {
                    this.advisor = (IBranchPolicyAdvisor)advisorElement.createExecutableExtension("class");
                    this.loadAdvisorCondition(advisorElement);
                }
                catch (CoreException e) {
                    Logger.log(e, "Failed to create Post Deactivator: " + this.getId());
                }
            }
        }
        return this.advisor;
    }

    private void loadAdvisorCondition(IConfigurationElement pdElement) {
        IConfigurationElement[] enablements = pdElement.getChildren("enablement");
        if (enablements.length == 0) {
            return;
        }
        try {
            this.advisorCondition = ExpressionConverter.getDefault().perform(enablements[0]);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to convert Post Deactivator expression: " + this.getId());
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof BranchPolicy)) {
            return false;
        }
        BranchPolicy that = (BranchPolicy)obj;
        return this.element == that.element;
    }
}

