/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import java.util.ArrayList;
import java.util.List;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.ui.internal.mindmap.MindMapPartBase;
import org.xmind.ui.mindmap.IConnectionPart;
import org.xmind.ui.mindmap.INodePart;

public abstract class NodePart
extends MindMapPartBase
implements INodePart {
    private List<IConnectionPart> sourceConnections = null;
    private List<IConnectionPart> targetConnections = null;

    @Override
    public List<IConnectionPart> getSourceConnections() {
        if (this.sourceConnections == null) {
            this.sourceConnections = this.initSourceConnections();
        }
        return this.sourceConnections;
    }

    protected List<IConnectionPart> initSourceConnections() {
        ArrayList<IConnectionPart> list = new ArrayList<IConnectionPart>();
        this.fillSourceConnections(list);
        return list;
    }

    protected abstract void fillSourceConnections(List<IConnectionPart> var1);

    @Override
    public void addSourceConnection(IConnectionPart connection) {
        if (this.getSourceConnections().contains(connection)) {
            return;
        }
        this.getSourceConnections().add(connection);
    }

    @Override
    public void removeSourceConnection(IConnectionPart connection) {
        if (this.getSourceConnections().contains(connection)) {
            this.getSourceConnections().remove(connection);
        }
    }

    @Override
    public List<IConnectionPart> getTargetConnections() {
        if (this.targetConnections == null) {
            this.targetConnections = this.initTargetConnections();
        }
        return this.targetConnections;
    }

    private List<IConnectionPart> initTargetConnections() {
        ArrayList<IConnectionPart> list = new ArrayList<IConnectionPart>();
        this.fillTargetConnections(list);
        return list;
    }

    protected abstract void fillTargetConnections(List<IConnectionPart> var1);

    @Override
    public void addTargetConnection(IConnectionPart connection) {
        if (this.getTargetConnections().contains(connection)) {
            return;
        }
        this.getTargetConnections().add(connection);
    }

    @Override
    public void removeTargetConnection(IConnectionPart connection) {
        if (this.getTargetConnections().contains(connection)) {
            this.getTargetConnections().remove(connection);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.refreshConnections();
    }

    public void removeNotify() {
        super.removeNotify();
        this.refreshConnections();
    }

    public void refresh() {
        super.refresh();
        this.refreshConnections();
    }

    protected void refreshConnections() {
        this.refreshSourceConnections();
        this.refreshTargetConnections();
    }

    protected void refreshSourceConnections() {
        Object[] objectArray = this.getSourceConnections().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object p = objectArray[n2];
            ((IGraphicalPart)p).refresh();
            ++n2;
        }
    }

    protected void refreshTargetConnections() {
        Object[] objectArray = this.getTargetConnections().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object p = objectArray[n2];
            ((IGraphicalPart)p).refresh();
            ++n2;
        }
    }

    public void update() {
        Object p;
        super.update();
        Object[] objectArray = this.getSourceConnections().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            p = objectArray[n2];
            ((IGraphicalPart)p).update();
            ++n2;
        }
        objectArray = this.getTargetConnections().toArray();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            p = objectArray[n2];
            ((IGraphicalPart)p).update();
            ++n2;
        }
    }
}

