/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.print.multipage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.image.FigureRenderer;
import org.xmind.gef.image.IExportSourceProvider;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.internal.print.PrintConstants;
import org.xmind.ui.internal.print.PrintUtils;
import org.xmind.ui.internal.print.multipage.PrintMultipageUtils;
import org.xmind.ui.mindmap.GhostShellProvider;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.mindmap.MindMapExportViewer;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.mindmap.MindMapViewerExportSourceProvider;
import org.xmind.ui.resources.ColorUtils;

public class PrintMultipagePreviewImageCreator {
    private static final String IMG_BG_COLOR = "#ffffff";
    private Display display;
    private IGraphicalEditorPage page;
    private IMindMap mindmap;
    private IDialogSettings settings;
    private IGraphicalViewer exportViewer;
    private IExportSourceProvider sourceProvider;
    private Image fullImage;
    private Image[][] singleImages;
    private boolean isSourceImageValid;
    private List<Image> images = new ArrayList<Image>();

    public PrintMultipagePreviewImageCreator(Display display, IGraphicalEditorPage page, IMindMap sourceMindmap, IDialogSettings settings) {
        this.display = display;
        this.page = page;
        this.mindmap = sourceMindmap;
        this.settings = settings;
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                PrintMultipagePreviewImageCreator.this.initSource();
            }
        });
    }

    private void initSource() {
        Properties properties = new Properties();
        properties.set("gradient", (Object)Boolean.FALSE);
        boolean plusVisible = this.getBoolean(this.settings, "plusVisible", true);
        boolean minusVisible = this.getBoolean(this.settings, "minusVisible", true);
        properties.set("plusVisible", plusVisible);
        properties.set("minusVisible", minusVisible);
        GhostShellProvider shell = new GhostShellProvider(this.display);
        this.exportViewer = new MindMapExportViewer(shell, (Object)this.mindmap, properties);
        this.sourceProvider = new MindMapViewerPrintSourceProvider(this.exportViewer, 0, this.settings);
    }

    private boolean getBoolean(IDialogSettings settings, String key, boolean defaultValue) {
        boolean value = defaultValue;
        if (settings.get(key) != null) {
            value = settings.getBoolean(key);
        }
        return value;
    }

    private Image getFullImage() {
        if (!this.isSourceImageValid && this.fullImage != null) {
            this.fullImage.dispose();
            this.fullImage = null;
        }
        if (this.fullImage == null || this.fullImage.isDisposed()) {
            this.fullImage = this.createFullImage();
        }
        return this.fullImage;
    }

    private Image createFullImage() {
        Rectangle bounds = PrintMultipageUtils.getSheetFigureBounds(this.page, this.mindmap);
        Image image = new Image((Device)this.display, bounds.width, bounds.height);
        final GC gc = new GC((Drawable)image);
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FigureRenderer render = new FigureRenderer();
                    render.setFigures(PrintMultipagePreviewImageCreator.this.sourceProvider.getContents());
                    int margin = PrintMultipageUtils.getMargin(PrintMultipagePreviewImageCreator.this.sourceProvider.getSourceArea());
                    render.setBounds(new Rectangle(PrintMultipagePreviewImageCreator.this.sourceProvider.getSourceArea()).expand(new Insets(margin)));
                    render.setScale(1.0);
                    render.render(gc, new Point(0, 0));
                }
            });
        }
        finally {
            gc.dispose();
        }
        this.isSourceImageValid = true;
        return image;
    }

    public Image createPrintPreviewSingleImage() {
        final int leftMarginPixel = PrintConstants.toPixel(this.getDouble("leftMargin", 0.2));
        int rightMarginPixel = PrintConstants.toPixel(this.getDouble("rightMargin", 0.2));
        final int topMarginPixel = PrintConstants.toPixel(this.getDouble("topMargin", 0.2));
        int bottomMarginPixel = PrintConstants.toPixel(this.getDouble("bottomMargin", 0.2));
        final int headerHeight = PrintUtils.getHeaderHeight(this.settings, 120);
        int footerHeight = PrintUtils.getBottomHeight(this.settings, 120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel - headerHeight - footerHeight;
        final Rectangle bounds = PrintMultipageUtils.getSheetFigureBounds(this.page, this.mindmap);
        double widthRatio = (double)usefulPerPageWidth / (double)bounds.width;
        double heightRatio = (double)usefulPerPageHeight / (double)bounds.height;
        final double ratio = Math.min(widthRatio, heightRatio);
        final int actualWidth = (int)((double)usefulPerPageWidth / ratio);
        final int actualHeight = (int)((double)usefulPerPageHeight / ratio);
        Image previewSingleImage = new Image((Device)this.display, (int)((double)perPageWidth / ratio), (int)((double)perPageHeight / ratio));
        this.images.add(previewSingleImage);
        final GC gc = new GC((Drawable)previewSingleImage);
        try {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FigureRenderer render = new FigureRenderer();
                    render.setFigures(PrintMultipagePreviewImageCreator.this.sourceProvider.getContents());
                    int margin = PrintMultipageUtils.getMargin(PrintMultipagePreviewImageCreator.this.sourceProvider.getSourceArea());
                    int widthPadding = (actualWidth - bounds.width) / 2;
                    int heightPadding = (actualHeight - bounds.height) / 2;
                    render.setBounds(new Rectangle(PrintMultipagePreviewImageCreator.this.sourceProvider.getSourceArea()).expand(new Insets(margin)).expand(new Insets(heightPadding, widthPadding, heightPadding, widthPadding)));
                    render.setScale(1.0);
                    gc.setClipping(new org.eclipse.swt.graphics.Rectangle((int)((double)leftMarginPixel / ratio), (int)((double)(topMarginPixel + headerHeight) / ratio), actualWidth, actualHeight));
                    render.render(gc, new Point((int)((double)leftMarginPixel / ratio), (int)((double)(topMarginPixel + headerHeight) / ratio)));
                }
            });
        }
        finally {
            gc.dispose();
        }
        return previewSingleImage;
    }

    public Image createPrintPreviewDetailedImage() {
        if (!this.checkImage()) {
            return null;
        }
        Image[][] images = this.getSingleImages2();
        int perWidth = images[0][0].getBounds().width;
        int width = perWidth * images[0].length;
        int perHeight = images[0][0].getBounds().height;
        int height = perHeight * images.length;
        Image detailedImage = new Image(images[0][0].getDevice(), width, height);
        this.images.add(detailedImage);
        GC gc = new GC((Drawable)detailedImage);
        try {
            int i = 0;
            while (i < images.length) {
                Image[] imageArr = images[i];
                int y = i * perHeight;
                int j = 0;
                while (j < imageArr.length) {
                    Image image = imageArr[j];
                    int x = j * perWidth;
                    gc.drawImage(image, x, y);
                    ++j;
                }
                ++i;
            }
        }
        finally {
            gc.dispose();
        }
        return detailedImage;
    }

    public Image[] getSingleImages() {
        if (!this.checkImage()) {
            return new Image[0];
        }
        Image[][] images = this.getSingleImages2();
        Image[] images2 = new Image[images.length * images[0].length];
        int i = 0;
        while (i < images.length) {
            int j = 0;
            while (j < images[0].length) {
                images2[i * images[0].length + j] = images[i][j];
                ++j;
            }
            ++i;
        }
        return images2;
    }

    private Image[][] getSingleImages2() {
        if (this.singleImages == null || this.singleImages[0] == null || this.singleImages[0][0] == null || this.singleImages[0][0].isDisposed()) {
            if (this.singleImages != null) {
                Image[][] imageArray = this.singleImages;
                int n = this.singleImages.length;
                int n2 = 0;
                while (n2 < n) {
                    Image[] images = imageArray[n2];
                    if (images != null) {
                        Image[] imageArray2 = images;
                        int n3 = images.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Image image = imageArray2[n4];
                            if (image != null) {
                                image.dispose();
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
            }
            this.singleImages = this.createSingleImages();
        }
        return this.singleImages;
    }

    private Image[][] createSingleImages() {
        boolean fullWidth;
        Rectangle bounds = PrintMultipageUtils.getSheetFigureBounds(this.page, this.mindmap);
        int sourceWidth = bounds.width;
        int sourceHeight = bounds.height;
        int leftMarginPixel = PrintConstants.toPixel(this.getDouble("leftMargin", 0.2));
        int rightMarginPixel = PrintConstants.toPixel(this.getDouble("rightMargin", 0.2));
        int topMarginPixel = PrintConstants.toPixel(this.getDouble("topMargin", 0.2));
        int bottomMarginPixel = PrintConstants.toPixel(this.getDouble("bottomMargin", 0.2));
        int headerHeight = PrintUtils.getHeaderHeight(this.settings, 120);
        int footerHeight = PrintUtils.getBottomHeight(this.settings, 120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel - headerHeight - footerHeight;
        int widthPages = this.getInteger("widthPages", 1);
        int heightPages = this.getInteger("heightPages", 1);
        boolean isAspectRatio = this.settings.getBoolean("aspectRatioLocked");
        boolean bl = fullWidth = !this.settings.getBoolean("fillHeight");
        if (!isAspectRatio) {
            double fillWidthratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            double fillHeightRatio = (double)usefulPerPageHeight * (double)heightPages / (double)sourceHeight;
            fullWidth = fillWidthratio <= fillHeightRatio;
        }
        double ratio = fullWidth ? (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth : (double)usefulPerPageHeight * (double)heightPages / (double)sourceHeight;
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / ratio);
        int usefulPerPageHeightByRatio = (int)((double)usefulPerPageHeight / ratio);
        int usefulWidthPages = widthPages;
        int usefulHeightPages = heightPages;
        if (fullWidth) {
            usefulHeightPages = sourceHeight / usefulPerPageHeightByRatio;
            usefulHeightPages = sourceHeight % usefulPerPageHeightByRatio == 0 ? usefulHeightPages : usefulHeightPages + 1;
        } else {
            usefulWidthPages = sourceWidth / usefulPerPageWidthByRatio;
            usefulWidthPages = sourceWidth % usefulPerPageWidthByRatio == 0 ? usefulWidthPages : usefulWidthPages + 1;
        }
        Image fullImage = this.getFullImage();
        Image[][] images = new Image[heightPages][widthPages];
        int j = 0;
        while (j < heightPages) {
            int y0 = j * usefulPerPageHeightByRatio;
            int height = sourceHeight - y0;
            height = Math.min(height, usefulPerPageHeightByRatio);
            int i = 0;
            while (i < widthPages) {
                int x0 = i * usefulPerPageWidthByRatio;
                int width = sourceWidth - x0;
                width = Math.min(width, usefulPerPageWidthByRatio);
                Image image = new Image((Device)this.display, (int)((double)perPageWidth / ratio), (int)((double)perPageHeight / ratio));
                this.images.add(image);
                GC gc = new GC((Drawable)image);
                try {
                    org.eclipse.swt.graphics.Rectangle imageBounds = image.getBounds();
                    gc.setBackground(ColorUtils.getColor((String)IMG_BG_COLOR));
                    gc.fillRectangle(0, 0, imageBounds.width - 1, imageBounds.height - 1);
                    int leftMarginByRatio = (int)((double)leftMarginPixel / ratio);
                    int topMarginByRation = (int)((double)(topMarginPixel + headerHeight) / ratio);
                    if (i < usefulWidthPages && j < usefulHeightPages) {
                        gc.drawImage(fullImage, x0, y0, width, height, leftMarginByRatio, topMarginByRation, width, height);
                    }
                }
                finally {
                    gc.dispose();
                }
                images[j][i] = image;
                ++i;
            }
            ++j;
        }
        return images;
    }

    public Image createPrintPreviewRoughImage(int controlWidth, int controlHeight) {
        boolean fullWidth;
        Rectangle bounds = PrintMultipageUtils.getSheetFigureBounds(this.page, this.mindmap);
        int sourceWidth = bounds.width;
        int sourceHeight = bounds.height;
        int leftMarginPixel = PrintConstants.toPixel(this.getDouble("leftMargin", 0.2));
        int rightMarginPixel = PrintConstants.toPixel(this.getDouble("rightMargin", 0.2));
        int topMarginPixel = PrintConstants.toPixel(this.getDouble("topMargin", 0.2));
        int bottomMarginPixel = PrintConstants.toPixel(this.getDouble("bottomMargin", 0.2));
        int headerHeight = PrintUtils.getHeaderHeight(this.settings, 120);
        int footerHeight = PrintUtils.getBottomHeight(this.settings, 120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel - headerHeight - footerHeight;
        int widthPages = this.getInteger("widthPages", 1);
        int heightPages = this.getInteger("heightPages", 1);
        boolean isAspectRatio = this.settings.getBoolean("aspectRatioLocked");
        boolean bl = fullWidth = !this.settings.getBoolean("fillHeight");
        if (!isAspectRatio) {
            double fillWidthratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            double fillHeightRatio = (double)usefulPerPageHeight * (double)heightPages / (double)sourceHeight;
            fullWidth = fillWidthratio <= fillHeightRatio;
        }
        double ratio = fullWidth ? (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth : (double)usefulPerPageHeight * (double)heightPages / (double)sourceHeight;
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / ratio);
        int usefulPerPageHeightByRatio = (int)((double)usefulPerPageHeight / ratio);
        int usefulWidthPages = widthPages;
        int usefulHeightPages = heightPages;
        if (fullWidth) {
            usefulHeightPages = sourceHeight / usefulPerPageHeightByRatio;
            usefulHeightPages = sourceHeight % usefulPerPageHeightByRatio == 0 ? usefulHeightPages : usefulHeightPages + 1;
        } else {
            usefulWidthPages = sourceWidth / usefulPerPageWidthByRatio;
            usefulWidthPages = sourceWidth % usefulPerPageWidthByRatio == 0 ? usefulWidthPages : usefulWidthPages + 1;
        }
        Image fullImage = this.getFullImage();
        Image image = new Image((Device)this.display, usefulPerPageWidthByRatio * widthPages, usefulPerPageHeightByRatio * heightPages);
        this.images.add(image);
        GC gc = new GC((Drawable)image);
        try {
            org.eclipse.swt.graphics.Rectangle imageBounds = image.getBounds();
            gc.setBackground(ColorUtils.getColor((String)IMG_BG_COLOR));
            gc.fillRectangle(0, 0, imageBounds.width - 1, imageBounds.height - 1);
            gc.drawImage(fullImage, 0, 0);
            gc.setForeground(ColorUtils.getColor((String)"#90d483"));
            double showRatio = Math.min((double)controlWidth / (double)imageBounds.width, (double)controlHeight / (double)imageBounds.height);
            int lineWidth = (int)(2.0 / showRatio);
            int showTickLength = 2;
            int tickLength = Math.max(1, (int)((double)showTickLength / showRatio));
            int showSpaceLength = 4;
            int spaceLength = Math.max(1, (int)((double)showSpaceLength / showRatio));
            gc.setLineWidth(lineWidth);
            int i = 1;
            while (i < widthPages) {
                PrintMultipagePreviewImageCreator.drawDashLine(gc, i * usefulPerPageWidthByRatio, 0, i * usefulPerPageWidthByRatio, imageBounds.height, tickLength, spaceLength, lineWidth);
                ++i;
            }
            i = 1;
            while (i < heightPages) {
                PrintMultipagePreviewImageCreator.drawDashLine(gc, 0, i * usefulPerPageHeightByRatio, imageBounds.width, i * usefulPerPageHeightByRatio, tickLength, spaceLength, lineWidth);
                ++i;
            }
            gc.setLineWidth(1);
            gc.setForeground(ColorUtils.getColor((String)"#c0c0c0"));
            gc.drawRectangle(0, 0, imageBounds.width - 1, imageBounds.height - 1);
        }
        finally {
            gc.dispose();
        }
        return image;
    }

    private double getDouble(String key, double defaultValue) {
        try {
            return this.settings.getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private int getInteger(String key, int defaultValue) {
        try {
            return this.settings.getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    public void releaseResource() {
        if (this.images != null) {
            Iterator<Image> ite = this.images.iterator();
            while (ite.hasNext()) {
                Image image = ite.next();
                if (image == null) continue;
                image.dispose();
                ite.remove();
                Object var2_2 = null;
            }
            this.images.clear();
        }
    }

    public void dispose() {
        this.releaseResource();
        if (this.fullImage != null) {
            this.fullImage.dispose();
        }
    }

    public boolean checkImage() {
        return !this.isImageLarge(100000000);
    }

    private boolean isImageLarge(int largeSize) {
        Rectangle bounds = PrintMultipageUtils.getSheetFigureBounds(this.page, this.mindmap);
        return bounds.width * bounds.height > largeSize;
    }

    public void setSourceImageValid(boolean isSourceImageValid) {
        this.isSourceImageValid = isSourceImageValid;
    }

    public void setShowBackground(boolean showBackground) {
        this.settings.put("noBackground", !showBackground);
    }

    public void setPlusVisible(boolean plusVisible) {
        if (this.exportViewer != null) {
            Properties properties = this.exportViewer.getProperties();
            properties.set("plusVisible", plusVisible);
        }
    }

    public void setMinusVisible(boolean minusVisible) {
        if (this.exportViewer != null) {
            Properties properties = this.exportViewer.getProperties();
            properties.set("minusVisible", minusVisible);
        }
    }

    private static void drawDashLine(GC gc, int x1, int y1, int x2, int y2, int tickLength, int spaceLength, int lineWidth) {
        if (x1 != x2 && y1 != y2) {
            throw new IllegalArgumentException("Must satisfy either 'x1 == x2' or 'y1 == y2'");
        }
        if (x1 == x2) {
            int times = Math.abs(y1 - y2) / (tickLength + spaceLength);
            int i = 0;
            while (i < times) {
                gc.drawLine(x1, i * (tickLength + spaceLength), x2, i * (tickLength + spaceLength) + tickLength);
                ++i;
            }
            int remainder = Math.abs(y1 - y2) % (tickLength + spaceLength);
            if (remainder > 0) {
                int length = remainder < tickLength ? remainder : tickLength;
                gc.drawLine(x1, times * (tickLength + spaceLength), x2, times * (tickLength + spaceLength) + length);
            }
        } else {
            int times = Math.abs(x1 - x2) / (tickLength + spaceLength);
            int i = 0;
            while (i < times) {
                gc.drawLine(i * (tickLength + spaceLength), y1, i * (tickLength + spaceLength) + tickLength, y2);
                ++i;
            }
            int remainder = Math.abs(x1 - x2) % (tickLength + spaceLength);
            if (remainder > 0) {
                int length = remainder < tickLength ? remainder : tickLength;
                gc.drawLine(times * (tickLength + spaceLength), y1, times * (tickLength + spaceLength) + length, y2);
            }
        }
    }

    private static class MindMapViewerPrintSourceProvider
    extends MindMapViewerExportSourceProvider {
        private IDialogSettings settings;

        public MindMapViewerPrintSourceProvider(IGraphicalViewer viewer, IDialogSettings settings) {
            super(viewer);
            this.settings = settings;
        }

        public MindMapViewerPrintSourceProvider(IGraphicalViewer viewer, int margins, IDialogSettings settings) {
            super(viewer, margins);
            this.settings = settings;
        }

        public IFigure[] getContents() {
            return this.collectContents();
        }

        private IFigure[] collectContents() {
            ArrayList<IFigure> figures = new ArrayList<IFigure>(3);
            this.collectContents(figures);
            return figures.toArray(new IFigure[figures.size()]);
        }

        @Override
        protected void collectContents(List<IFigure> figures) {
            if (this.settings != null && !this.settings.getBoolean("noBackground")) {
                figures.add((IFigure)this.getViewer().getLayer(GEF.LAYER_BACKGROUND));
            }
            figures.add((IFigure)this.getViewer().getLayer(GEF.LAYER_CONTENTS));
            figures.add((IFigure)this.getViewer().getLayer(MindMapUI.LAYER_TITLE));
        }
    }
}

