/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.iconfinder;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.xmind.ui.internal.iconfinder.IconfinderActivator;
import org.xmind.ui.io.DownloadJob;

public class DownloadJobPool {
    private static boolean DEBUG = IconfinderActivator.getDebugOption("/debug/downloadpool");
    private static final int DEFAULT_RETRY_NUM = 0;
    private static final int DEFAULT_RUNNING_MAX_NUM = 5;
    private Queue<DownloadTask> waitingJobs = new ConcurrentLinkedQueue<DownloadTask>();
    private int runningJobCount = 0;

    public void scheduleDownloadJob(DownloadJob job, Runnable onFinish) {
        this.waitingJobs.offer(new DownloadTask(job, onFinish));
        this.scheduleNext();
    }

    public void cancelRemaining() {
        this.waitingJobs.clear();
    }

    private synchronized void scheduleNext() {
        DownloadTask task;
        if (this.runningJobCount < 5 && (task = this.waitingJobs.poll()) != null) {
            try {
                this.startDownloadJob(task.job, task.onFinish);
            }
            catch (Throwable e) {
                IconfinderActivator.log(e, "Error occurred while downloading");
            }
            ++this.runningJobCount;
        }
    }

    private void startDownloadJob(final DownloadJob job, final Runnable onFinish) {
        final int[] retryCount = new int[1];
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                super.done(event);
                int status = event.getJob().getResult().getSeverity();
                if (status != 0 && status != 8) {
                    retryCount[0] = retryCount[0] + 1;
                    if (retryCount[0] < 0) {
                        job.schedule();
                        if (DEBUG) {
                            System.out.println("Retry failed download [try=" + (retryCount[0] + 1) + "]: " + job.getSourceURL());
                        }
                        return;
                    }
                    if (DEBUG) {
                        System.out.println("Download failed after 3 retries: " + job.getSourceURL());
                    }
                } else if (DEBUG) {
                    if (status == 0) {
                        System.out.println("Download succeeded: " + job.getSourceURL());
                    } else {
                        System.out.println("Download canceled: " + job.getSourceURL());
                    }
                }
                try {
                    if (onFinish != null) {
                        try {
                            onFinish.run();
                        }
                        catch (Throwable e) {
                            IconfinderActivator.log(e, "Error occurred while calling back on download finished: " + job.getSourceURL());
                        }
                    }
                }
                finally {
                    DownloadJobPool downloadJobPool = DownloadJobPool.this;
                    downloadJobPool.runningJobCount = downloadJobPool.runningJobCount - 1;
                    DownloadJobPool.this.scheduleNext();
                }
            }
        });
        job.schedule();
        if (DEBUG) {
            System.out.println("New download job start [try=" + (retryCount[0] + 1) + "]: " + job.getSourceURL() + " -> " + job.getTargetPath());
        }
    }

    private static class DownloadTask {
        final DownloadJob job;
        final Runnable onFinish;

        public DownloadTask(DownloadJob job, Runnable onFinish) {
            this.job = job;
            this.onFinish = onFinish;
        }
    }
}

