/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.event;

import org.xmind.core.IAdaptable;
import org.xmind.core.event.CoreEventRegisterBase;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.event.NullCoreEventRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreEventRegister
extends CoreEventRegisterBase {
    private ICoreEventSource source;
    private ICoreEventSupport support;
    private ICoreEventListener listener;

    public CoreEventRegister() {
    }

    public CoreEventRegister(ICoreEventSource source) {
        this.source = source;
        this.support = null;
        this.listener = null;
    }

    public CoreEventRegister(ICoreEventSupport support) {
        this.support = support;
        this.source = null;
        this.listener = null;
    }

    public CoreEventRegister(ICoreEventListener listener) {
        this.source = null;
        this.support = null;
        this.listener = listener;
    }

    public CoreEventRegister(ICoreEventSource source, ICoreEventListener listener) {
        this.source = source;
        this.support = null;
        this.listener = listener;
    }

    public CoreEventRegister(ICoreEventSupport support, ICoreEventListener listener) {
        this.source = null;
        this.support = support;
        this.listener = listener;
    }

    public CoreEventRegister(Object source, ICoreEventListener listener) {
        this.source = (ICoreEventSource)CoreEventRegister.getAdapter(source, ICoreEventSource.class);
        this.support = this.source == null ? (ICoreEventSupport)CoreEventRegister.getAdapter(source, ICoreEventSupport.class) : null;
        this.listener = listener;
    }

    @Override
    public ICoreEventRegistration register(String eventType) {
        ICoreEventRegistration reg;
        if (this.listener == null) {
            return NullCoreEventRegistration.getInstance();
        }
        if (this.source != null) {
            reg = this.source.registerCoreEventListener(eventType, this.listener);
            this.addRegistration(reg);
        } else if (this.support != null) {
            reg = this.support.registerGlobalListener(eventType, this.listener);
            this.addRegistration(reg);
        } else {
            reg = NullCoreEventRegistration.getInstance();
        }
        return reg;
    }

    @Override
    public void setNextListener(ICoreEventListener listener) {
        this.listener = listener;
    }

    @Override
    public void setNextSource(ICoreEventSource source) {
        this.source = source;
        this.support = null;
    }

    @Override
    public void setNextSupport(ICoreEventSupport support) {
        this.source = null;
        this.support = support;
    }

    @Override
    public void setNextSourceFrom(Object source) {
        this.source = (ICoreEventSource)CoreEventRegister.getAdapter(source, ICoreEventSource.class);
        this.support = this.source == null ? (ICoreEventSupport)CoreEventRegister.getAdapter(source, ICoreEventSupport.class) : null;
    }

    private static Object getAdapter(Object adaptable, Class<?> adapter) {
        if (adapter.isInstance(adaptable)) {
            return adaptable;
        }
        if (IAdaptable.class.isInstance(adaptable)) {
            return ((IAdaptable)adaptable).getAdapter(adapter);
        }
        return null;
    }
}

