/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IDeserializer;
import org.xmind.core.IEncryptionData;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.IEntryStreamNormalizer;
import org.xmind.core.IFileEntry;
import org.xmind.core.ISerializer;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.AbstractWorkbookBuilder;
import org.xmind.core.internal.dom.DeserializerImpl;
import org.xmind.core.internal.dom.MetaImpl;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.SerializerImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.security.Crypto;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.io.ChecksumTrackingOutputStream;
import org.xmind.core.io.ChecksumVerifiedInputStream;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;

public class WorkbookBuilderImpl
extends AbstractWorkbookBuilder {
    protected synchronized Document createDocument() {
        DocumentBuilder docBuilder;
        try {
            docBuilder = DOMUtils.getDefaultDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        return docBuilder.newDocument();
    }

    protected synchronized DocumentBuilder getDocumentLoader() throws CoreException {
        try {
            DocumentBuilder loader = DOMUtils.getDefaultDocumentBuilder();
            return loader;
        }
        catch (ParserConfigurationException e) {
            throw new CoreException(12, (Throwable)e);
        }
    }

    protected IWorkbook doCreateWorkbook(IStorage storage) {
        String org;
        String email;
        if (storage == null) {
            storage = new ByteArrayStorage();
        }
        storage.clear();
        Document contentDoc = this.createDocument();
        WorkbookImpl workbook = new WorkbookImpl(contentDoc, storage);
        MetaImpl meta = workbook.getMeta();
        String name = System.getProperty("org.xmind.author.name");
        if (name == null) {
            name = System.getProperty("user.name");
        }
        if (name != null) {
            meta.setValue("Author/Name", name);
        }
        if ((email = System.getProperty("org.xmind.author.email")) != null) {
            meta.setValue("Author/Email", email);
        }
        if ((org = System.getProperty("org.xmind.author.org")) != null) {
            meta.setValue("Author/Org", org);
        }
        if (meta.getValue("Create/Time") == null) {
            meta.setValue("Create/Time", NumberUtils.formatDate(System.currentTimeMillis()));
        }
        meta.setValue("Creator/Name", this.getCreatorName());
        meta.setValue("Creator/Version", this.getCreatorVersion());
        return workbook;
    }

    public IDeserializer newDeserializer() {
        DeserializerImpl deserializer = new DeserializerImpl();
        deserializer.setCreatorName(this.getCreatorName());
        deserializer.setCreatorVersion(this.getCreatorVersion());
        return deserializer;
    }

    public ISerializer newSerializer() {
        SerializerImpl serializer = new SerializerImpl();
        serializer.setCreatorName(this.getCreatorName());
        serializer.setCreatorVersion(this.getCreatorVersion());
        return serializer;
    }

    protected IWorkbook doLoadFromInputSource(IInputSource source, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        IDeserializer deserializer = Core.getWorkbookBuilder().newDeserializer();
        deserializer.setCreatorName(this.getCreatorName());
        deserializer.setCreatorVersion(this.getCreatorVersion());
        deserializer.setWorkbookStorage(storage);
        deserializer.setEntryStreamNormalizer(new LegacyEncryptionNormalizerAdapter(encryptionHandler));
        deserializer.setInputSource(source);
        deserializer.deserialize(null);
        return deserializer.getWorkbook();
    }

    protected IWorkbook doLoadFromStream(InputStream in, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        IDeserializer deserializer = Core.getWorkbookBuilder().newDeserializer();
        deserializer.setCreatorName(this.getCreatorName());
        deserializer.setCreatorVersion(this.getCreatorVersion());
        deserializer.setWorkbookStorage(storage);
        deserializer.setEntryStreamNormalizer(new LegacyEncryptionNormalizerAdapter(encryptionHandler));
        deserializer.setInputStream(in);
        deserializer.deserialize(null);
        return deserializer.getWorkbook();
    }

    protected IWorkbook doLoadFromStorage(IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        IDeserializer deserializer = Core.getWorkbookBuilder().newDeserializer();
        deserializer.setCreatorName(this.getCreatorName());
        deserializer.setCreatorVersion(this.getCreatorVersion());
        deserializer.setWorkbookStorage(storage);
        deserializer.setEntryStreamNormalizer(new LegacyEncryptionNormalizerAdapter(encryptionHandler));
        deserializer.setWorkbookStorageAsInputSource();
        deserializer.deserialize(null);
        return deserializer.getWorkbook();
    }

    @Deprecated
    protected void extractFromStream(InputStream input, IOutputTarget target) throws IOException, CoreException {
        ZipInputStream zip = new ZipInputStream(input);
        try {
            FileUtils.extractZipFile(zip, target);
        }
        finally {
            zip.close();
        }
    }

    private static class LegacyEncryptionNormalizerAdapter
    implements IEntryStreamNormalizer {
        private final IEncryptionHandler encryptionHandler;

        public LegacyEncryptionNormalizerAdapter(IEncryptionHandler encryptionHandler) {
            this.encryptionHandler = encryptionHandler;
        }

        public OutputStream normalizeOutputStream(OutputStream stream, IFileEntry fileEntry) throws IOException, CoreException {
            fileEntry.deleteEncryptionData();
            IEncryptionData encData = fileEntry.createEncryptionData();
            Crypto.initEncryptionData(encData);
            OutputStream out = Crypto.creatOutputStream(stream, true, encData, this.encryptionHandler.retrievePassword());
            if (encData.getChecksumType() != null) {
                return new ChecksumTrackingOutputStream(encData, out);
            }
            return out;
        }

        public InputStream normalizeInputStream(InputStream stream, IFileEntry fileEntry) throws IOException, CoreException {
            IEncryptionData encData = fileEntry.getEncryptionData();
            if (encData == null) {
                return stream;
            }
            InputStream in = Crypto.createInputStream(stream, false, encData, this.encryptionHandler.retrievePassword());
            if (encData.getChecksumType() != null) {
                return new ChecksumVerifiedInputStream(in, encData.getChecksum());
            }
            return in;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof LegacyEncryptionNormalizerAdapter)) {
                return false;
            }
            LegacyEncryptionNormalizerAdapter that = (LegacyEncryptionNormalizerAdapter)obj;
            return this.encryptionHandler.equals(that.encryptionHandler);
        }
    }
}

