/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IEvaluationService;
import org.xmind.core.Core;
import org.xmind.core.IBoundary;
import org.xmind.core.IControlPoint;
import org.xmind.core.IRelationship;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IStorage;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.style.IStyled;
import org.xmind.core.util.Property;
import org.xmind.gef.EditDomain;
import org.xmind.gef.GEF;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.service.CenterPreservationService;
import org.xmind.gef.service.FeedbackService;
import org.xmind.gef.service.IFeedbackService;
import org.xmind.gef.service.IRevealService;
import org.xmind.gef.service.IViewerService;
import org.xmind.gef.tool.ITool;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.handlers.RedoStylePropertyChangeAction;
import org.xmind.ui.internal.handlers.UndoStylePropertyChangeAction;
import org.xmind.ui.internal.mindmap.MindMapRevealService;
import org.xmind.ui.internal.mindmap.MindMapViewer;
import org.xmind.ui.internal.styleeditor.AdvancedStylesViewer2;
import org.xmind.ui.internal.styleeditor.StyleEditModel;
import org.xmind.ui.internal.styleeditor.StyleEditorMessages;
import org.xmind.ui.internal.styleeditor.StyleEditorPlugin;
import org.xmind.ui.internal.styleeditor.StylePropertySource;
import org.xmind.ui.internal.styleeditor.StylePropertyTransfer;
import org.xmind.ui.internal.tools.MindMapSelectTool;
import org.xmind.ui.mindmap.IResourceManager;
import org.xmind.ui.mindmap.MindMap;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.IPropertySource;
import org.xmind.ui.properties.IPropertyTransfer;
import org.xmind.ui.properties.PropertiesEditor;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleEditorDialog
extends Dialog {
    public static final String KEY_STYLE_EDITOR_MODEL = "org.xmind.ui.styleEditorDialog.StyleEditorModel";
    public static final String KEY_STYLESVIEWER = "org.xmind.ui.styleEditorDialog.StylesViewer";
    private static final String KEY_SELECTION_PROVIDER = "org.xmind.ui.styleEditorDialog.selectionProvider";
    private static final String SETTINGS_SECTION = "org.xmind.ui.StyleEditorDialog";
    private static final String GROUP_FILE = "group.file";
    private static final String GROUP_OPEN = "group.open";
    private static final String GROUP_SHOW_IN = "group.showIn";
    private static final String GROUP_EDIT = "group.edit";
    private static final String GROUP_REORGANIZE = "group.reorganize";
    private static final String GROUP_GENERATE = "group.generate";
    private static final String GROUP_PROPERTIES = "group.properties";
    protected static final int DECISION_NONE = -2;
    protected static final int NO_DECISION = 3;
    protected IWorkbenchWindow parentWindow;
    private Composite container;
    private Viewer stylesViewer;
    private StyleEditModel model;
    private PropertiesEditor editor;
    private MindMapViewer previewer;
    private IWorkbook previewWorkbook;
    private IStyle inputStyle;
    private IStyle previewStyle;
    private IStorage previewStorage;
    private Collection<IStyled> previewStyleds;
    private IContextActivation contextActivation;
    protected PropertyChangeListener modelListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("__dirty__".equals(event.getPropertyName())) {
                StyleEditorDialog.this.updateDirtyState();
            } else if (!"org.xmind.core.name".equals(event.getPropertyName()) && !"org.xmind.ui.displayname".equals(event.getPropertyName())) {
                StyleEditorDialog.this.updatePreview((StyleEditModel)event.getSource());
            }
            if (StyleEditorDialog.this.editor != null) {
                StyleEditorDialog.this.editor.updateAll();
                StyleEditorDialog.this.editor.reflow();
            }
        }
    };
    private UndoStylePropertyChangeAction undoAction = new UndoStylePropertyChangeAction();
    private RedoStylePropertyChangeAction redoAction = new RedoStylePropertyChangeAction();
    private Collection<IHandlerActivation> handlerActivations = new ArrayList<IHandlerActivation>();
    private CurrentSelectionProviderWrap currentSelectionProviderWrap = null;

    public StyleEditorDialog(IWorkbenchWindow window, IStyle style) {
        super(window.getShell());
        this.initPreviewStorage();
        this.parentWindow = window;
        this.model = this.initModel(style);
        this.setBlockOnOpen(true);
    }

    private void initPreviewStorage() {
        File root = StyleEditorPlugin.getDefault().getStateLocation().toFile();
        root = new File(root, ".preview");
        File dir = new File(root, UUID.randomUUID().toString());
        dir.mkdirs();
        this.previewStorage = new DirectoryStorage(dir);
        this.previewWorkbook = Core.getWorkbookBuilder().createWorkbook(this.previewStorage);
    }

    protected StyleEditModel initModel(IStyle style) {
        this.inputStyle = style;
        IStyleSheet previewStyleSheet = this.previewWorkbook.getStyleSheet();
        this.previewStyle = this.importDiffentIdStyle(style, previewStyleSheet);
        String resourceURI = StyleEditModel.generateAnonymousURI(this.previewStyle);
        StyleEditModel model = StyleEditModel.loadAnonymousStyle(this.previewStyle, resourceURI, this.previewStyle.getName());
        return model;
    }

    private IStyle importDiffentIdStyle(IStyle style, IStyleSheet styleSheet) {
        IStyle newStyle = styleSheet.importStyle(style);
        if (newStyle == null) {
            newStyle = styleSheet.createStyle(style.getType());
            newStyle.setName(style.getName());
        } else {
            IStyle diffentIdStyle = styleSheet.createStyle(newStyle.getType());
            Iterator properties = newStyle.properties();
            while (properties.hasNext()) {
                Property property = (Property)properties.next();
                diffentIdStyle.setProperty(property.key, property.value);
            }
            diffentIdStyle.setName(style.getName());
            newStyle = diffentIdStyle;
        }
        styleSheet.addStyle(newStyle, "normal-styles");
        return newStyle;
    }

    public StyleEditModel getModel() {
        return this.model;
    }

    public void create() {
        super.create();
        this.updateDirtyState();
        this.updatePreview(this.model);
        this.registerSourceProvider();
    }

    private void registerSourceProvider() {
        this.currentSelectionProviderWrap = new CurrentSelectionProviderWrap();
        this.currentSelectionProviderWrap.notifySelectionChanges();
        final Listener focusListener = new Listener(){

            public void handleEvent(Event event) {
                if (StyleEditorDialog.this.currentSelectionProviderWrap == null) {
                    return;
                }
                Widget w = event.widget;
                ISelectionProvider selectionProvider = null;
                while (w != null) {
                    selectionProvider = (ISelectionProvider)w.getData(StyleEditorDialog.KEY_SELECTION_PROVIDER);
                    if (selectionProvider != null) break;
                    if (!(w instanceof Control)) continue;
                    w = ((Control)w).getParent();
                }
                StyleEditorDialog.this.currentSelectionProviderWrap.setSelectionProvider(selectionProvider);
            }
        };
        final Display display = Display.getCurrent();
        display.addFilter(15, focusListener);
        this.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                display.removeFilter(15, focusListener);
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.container = new Composite(composite, 2048);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.container.setLayout((Layout)gridLayout);
        GridData layoutData = new GridData(4, 4, true, true);
        Rectangle maxSize = parent.getMonitor().getClientArea();
        layoutData.widthHint = Math.min(maxSize.width - 200, 900);
        layoutData.heightHint = Math.min(maxSize.height - 100, 500);
        this.container.setLayoutData((Object)layoutData);
        SashForm form = new SashForm(this.container, 65792);
        form.setLayoutData((Object)new GridData(4, 4, true, true));
        Control styleSection = this.createStyleSection((Composite)form);
        Control previewSection = this.createPreview((Composite)form);
        Control editorSection = this.createEditor((Composite)form);
        int count = 0;
        if (styleSection != null) {
            ++count;
        }
        if (previewSection != null) {
            ++count;
        }
        if (editorSection != null) {
            ++count;
        }
        switch (count) {
            case 2: {
                form.setWeights(new int[]{2, 1});
                break;
            }
            case 3: {
                form.setWeights(new int[]{1, 2, 1});
            }
        }
        this.createPopupMenu();
        this.model.addListener(this.modelListener);
        this.container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StyleEditorDialog.this.handleDispose();
            }
        });
        return composite;
    }

    private Control createStyleSection(Composite parent) {
        this.stylesViewer = this.createStyleViewer(parent);
        if (this.stylesViewer == null) {
            return null;
        }
        Control stylesViewerControl = this.stylesViewer.getControl();
        stylesViewerControl.setData(KEY_SELECTION_PROVIDER, (Object)this.stylesViewer);
        stylesViewerControl.setData(KEY_STYLE_EDITOR_MODEL, (Object)this.model);
        stylesViewerControl.getShell().setData(KEY_STYLESVIEWER, (Object)this.stylesViewer);
        MenuManager menu = new MenuManager("#PopupMenu");
        menu.add((IContributionItem)new Separator(GROUP_FILE));
        menu.add((IContributionItem)new Separator(GROUP_OPEN));
        menu.add((IContributionItem)new GroupMarker(GROUP_SHOW_IN));
        menu.add((IContributionItem)new Separator(GROUP_EDIT));
        menu.add((IContributionItem)new Separator(GROUP_REORGANIZE));
        menu.add((IContributionItem)new Separator(GROUP_GENERATE));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator(GROUP_PROPERTIES));
        IMenuService menuService = (IMenuService)this.parentWindow.getWorkbench().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)menu, "popup:org.xmind.ui.StylesDisplay");
        ((Composite)stylesViewerControl).setMenu(menu.createContextMenu(stylesViewerControl));
        this.stylesViewer.setInput(this.getStyleViewerInput());
        this.stylesViewer.setSelection(this.getFirstSelectedElement(), true);
        this.stylesViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        return stylesViewerControl;
    }

    protected ISelection getFirstSelectedElement() {
        if (this.inputStyle != null) {
            return new StructuredSelection((Object)this.inputStyle);
        }
        return StructuredSelection.EMPTY;
    }

    private ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selected = event.getSelection();
                if (selected != null && selected instanceof StructuredSelection) {
                    StructuredSelection ss = (StructuredSelection)selected;
                    Object obj = ss.getFirstElement();
                    int decision = StyleEditorDialog.this.demandSaveDialog(obj);
                    if (decision == 0 || decision == 2 || decision == -1 || decision == -2) {
                        return;
                    }
                    if (obj instanceof IStyle) {
                        IStyle style = StyleEditorDialog.this.transformIntoPreselectedStyle((IStyle)obj);
                        StyleEditorDialog.this.updateForChangeModel(style);
                    } else if (obj instanceof String) {
                        if (StyleEditorDialog.this.stylesViewer != null) {
                            StyleEditorDialog.this.stylesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                        }
                        IStyle styleCreated = StyleEditorDialog.this.updateForCreateNew(obj);
                        StyleEditorDialog.this.inputStyle = styleCreated;
                        if (StyleEditorDialog.this.stylesViewer != null) {
                            StyleEditorDialog.this.stylesViewer.setSelection((ISelection)new StructuredSelection((Object)styleCreated), true);
                        }
                    }
                }
            }
        };
    }

    protected IStyle updateForCreateNew(Object obj) {
        String type = this.model.getType();
        IStyle styleCreated = MindMapUI.getResourceManager().getUserStyleSheet().createStyle(type);
        styleCreated.setName(StyleEditorMessages.StyleEditorDialog_NewStyle_UntitledName);
        MindMapUI.getResourceManager().getUserStyleSheet().addStyle(styleCreated, "normal-styles");
        MindMapUI.getResourceManager().saveUserStyleSheet();
        VerifyUI20141031.getUsageDataCollector().increase("CreateStyleCount");
        return styleCreated;
    }

    protected int demandSaveDialog(Object selectedStyle) {
        if (this.inputStyle.equals(selectedStyle)) {
            return -2;
        }
        if (this.inputStyle instanceof IStyle && !this.inputStyle.equals(selectedStyle) && this.getModel().isDirty()) {
            String message = StyleEditorMessages.StyleEditorDialog_SaveModifiedStyleBeforeClose_warningMessage;
            int decision = new QuestionDialog(this.getShell(), StyleEditorMessages.StyleEditorDialog_dialogTitle, message).open();
            if (decision == 2 || decision == -1) {
                if (this.stylesViewer != null) {
                    this.stylesViewer.setSelection((ISelection)new StructuredSelection((Object)this.inputStyle), true);
                }
            } else if (decision == 1) {
                this.model.clean();
            } else if (decision == 0) {
                this.saveModel();
            }
            return decision;
        }
        return 3;
    }

    protected IStyle transformIntoPreselectedStyle(IStyle style) {
        this.inputStyle = style;
        IStyleSheet previewStyleSheet = this.previewWorkbook.getStyleSheet();
        this.previewStyle = this.importDiffentIdStyle(style, previewStyleSheet);
        return this.previewStyle;
    }

    protected void updateForChangeModel(IStyle style) {
        if (style == null) {
            return;
        }
        this.model.removeListener(this.modelListener);
        String resourceURI = StyleEditModel.generateAnonymousURI(style);
        this.model = StyleEditModel.loadAnonymousStyle(style, resourceURI, style.getName());
        if (this.stylesViewer != null) {
            this.stylesViewer.getControl().setData(KEY_STYLE_EDITOR_MODEL, (Object)this.model);
        }
        if (this.undoAction == null) {
            this.undoAction = new UndoStylePropertyChangeAction();
        }
        this.undoAction.setModel(this.model);
        if (this.redoAction == null) {
            this.redoAction = new RedoStylePropertyChangeAction();
        }
        this.redoAction.setModel(this.model);
        this.model.addListener(this.modelListener);
        if (this.editor != null) {
            this.editor.setPopupMenu(null);
            this.editor.setInput((IPropertySource)new StylePropertySource(this.getModel(), UUID.randomUUID().toString()));
            this.createPopupMenu();
            ((ScrolledComposite)this.editor.getControl()).layout(true, true);
        }
        this.updateDirtyState();
        this.updatePreview(this.model);
    }

    protected Viewer createStyleViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label title = new Label(composite, 16384);
        title.setText(this.getStyleViewerTitle(this.model.getType()));
        title.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)2));
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 4, true, false));
        AdvancedStylesViewer2 viewer = new AdvancedStylesViewer2(this.model.getType());
        viewer.createControl(composite, 0);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        return viewer;
    }

    private String getStyleViewerTitle(String styleStype) {
        if ("topic".equals(styleStype)) {
            return StyleEditorMessages.StyleEditorDialog_StyleViewer_StyleType_topic;
        }
        if ("boundary".equals(styleStype)) {
            return StyleEditorMessages.StyleEditorDialog_StyleViewer_StyleType_boundary;
        }
        if ("relationship".equals(styleStype)) {
            return StyleEditorMessages.StyleEditorDialog_StyleViewer_StyleType_Relationship;
        }
        if ("map".equals(styleStype)) {
            return StyleEditorMessages.StyleEditorDialog_StyleViewer_StyleType_sheet;
        }
        return StyleEditorMessages.StyleEditorDialog_StyleViewer_StyleType_styles;
    }

    protected Object getStyleViewerInput() {
        IResourceManager resourceManager = MindMapUI.getResourceManager();
        IStyleSheet systemStyleSheet = resourceManager.getSystemStyleSheet();
        Set systemStyles = systemStyleSheet.getStyles("automatic-styles");
        HashSet<IStyle> removingSysStyles = new HashSet<IStyle>();
        for (IStyle style : systemStyles) {
            if (this.model.getType().equals(style.getType())) continue;
            removingSysStyles.add(style);
        }
        systemStyles.removeAll(removingSysStyles);
        IStyleSheet userStyleSheet = resourceManager.getUserStyleSheet();
        Set userStyles = userStyleSheet.getAllStyles();
        HashSet<IStyle> removingUserStyles = new HashSet<IStyle>();
        for (IStyle style : userStyles) {
            if (this.model.getType().equals(style.getType())) continue;
            removingUserStyles.add(style);
        }
        userStyles.removeAll(removingUserStyles);
        ArrayList<Object> input = new ArrayList<Object>(systemStyles.size() + userStyles.size() + 1);
        input.add(AdvancedStylesViewer2.ADD_STYLE);
        input.addAll(this.getReversed(userStyles));
        input.addAll(systemStyles);
        return input;
    }

    private List<Object> getReversed(Collection<?> sourceList) {
        LinkedList<Object> targetList = new LinkedList<Object>();
        for (Object item : sourceList) {
            targetList.add(0, item);
        }
        return targetList;
    }

    private Control createEditor(Composite parent) {
        parent = this.createEditorTopSection(parent);
        this.editor = new PropertiesEditor();
        this.editor.setColorFontOverrides("org.xmind.ui.color.PropertiesEditor.background", "org.xmind.ui.color.StyleEditor.propertiesEditor.background");
        this.editor.setColorFontOverrides("org.xmind.ui.color.PropertiesEditor.categoryTitle.foreground", "org.xmind.ui.color.StyleEditor.categoryTitle.foreground");
        this.editor.setColorFontOverrides("org.xmind.ui.color.PropertiesEditor.entry.foreground", "org.xmind.ui.color.StyleEditor.propertyEditingEntry.foreground");
        this.editor.setColorFontOverrides("org.xmind.ui.font.PropertiesEditor.categoryTitle", "org.xmind.ui.font.StyleEditor.categoryTitle");
        this.editor.setColorFontOverrides("org.xmind.ui.font.PropertiesEditor.entry", "org.xmind.ui.font.StyleEditor.propertyEditingEntry");
        this.editor.setColorFontOverrides("org.xmind.ui.color.PropertiesEditor.entry.selected.background", "org.xmind.ui.color.StyleEditor.propertyEditingEntry.selected.background");
        this.editor.setColorFontOverrides("org.xmind.ui.color.PropertiesEditor.entry.selected.foreground", "org.xmind.ui.color.StyleEditor.propertyEditingEntry.selected.foreground");
        this.editor.setColorFontOverrides("org.xmind.ui.font.PropertiesEditor.entry.selected", "org.xmind.ui.font.StyleEditor.propertyEditingEntry.selected");
        this.editor.setTransfer((IPropertyTransfer)new StylePropertyTransfer());
        ArrayList<String> filtedDescriptorIds = new ArrayList<String>();
        filtedDescriptorIds.add("callout-shape-class");
        this.editor.setFilter(filtedDescriptorIds);
        if (this.getModel() != null) {
            this.editor.setInput((IPropertySource)new StylePropertySource(this.getModel(), UUID.randomUUID().toString()));
        }
        this.editor.create(parent);
        this.editor.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.editor.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                StyleEditorDialog.this.editor.updateAll();
            }
        });
        this.editor.getControl().setData(KEY_SELECTION_PROVIDER, (Object)this.editor);
        return this.editor.getControl();
    }

    protected PropertiesEditor getPropertiesEditor() {
        return this.editor;
    }

    protected Composite createEditorTopSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label title = new Label(composite, 16384);
        title.setText(StyleEditorMessages.StyleEditorDialog_EditorTopSection_title);
        title.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)2));
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 4, true, false));
        return composite;
    }

    private Control createPreview(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.previewer = new StyleEditorMindMapViewer();
        this.previewer.getProperties().set("margin", 100);
        this.previewer.getProperties().set("cornered", true);
        this.previewer.getProperties().set("centered", true);
        EditDomain editDomain = new EditDomain();
        editDomain.installTool("select tool", (ITool)new MindMapSelectTool());
        this.previewer.setEditDomain(editDomain);
        CenterPreservationService centerPresercationService = new CenterPreservationService((IGraphicalViewer)this.previewer, true);
        this.previewer.installService(CenterPreservationService.class, (IViewerService)centerPresercationService);
        centerPresercationService.setActive(true);
        Layer feedbackLayer = this.previewer.getLayer(GEF.LAYER_FEEDBACK);
        if (feedbackLayer != null) {
            FeedbackService feedbackService = new FeedbackService((IGraphicalViewer)this.previewer);
            this.previewer.installService(IFeedbackService.class, (IViewerService)feedbackService);
            feedbackService.setLayer((IFigure)feedbackLayer);
            feedbackService.setSelectionColorProvider(new IColorProvider(){

                public Color getBackground(Object element) {
                    if (IFeedbackService.PreselectionColor.equals(element) || IFeedbackService.DisabledPreselectionColor.equals(element)) {
                        return ColorUtils.getColor((String)"#80c0d0");
                    }
                    return null;
                }

                public Color getForeground(Object element) {
                    if (IFeedbackService.FocusColor.equals(element)) {
                        return ColorUtils.getColor((String)"#1020f0");
                    }
                    if (IFeedbackService.SelectionColor.equals(element)) {
                        return ColorUtils.getColor((String)"#1040a8");
                    }
                    if (IFeedbackService.PreselectionColor.equals(element) || IFeedbackService.DisabledPreselectionColor.equals(element)) {
                        return ColorUtils.getColor((String)"#a8c0d8");
                    }
                    if (IFeedbackService.DisabledFocusColor.equals(element)) {
                        return ColorUtils.getColor((String)"#606060");
                    }
                    if (IFeedbackService.DisabledSelectionColor.equals(element)) {
                        return ColorUtils.getColor((String)"#808080");
                    }
                    return null;
                }
            });
            feedbackService.setSelectionLineWidth(4);
            feedbackService.setSelectionCorner(5);
            feedbackService.setActive(true);
        }
        MindMapRevealService revealService = new MindMapRevealService((IGraphicalViewer)this.previewer);
        this.previewer.installService(IRevealService.class, (IViewerService)revealService);
        revealService.setActive(true);
        this.addExtraCapacityForPreview(this.previewer);
        this.previewer.createControl(composite);
        parent.getShell().setData("MindMapViewer", (Object)this.previewer);
        ISheet sheet = this.previewWorkbook.getPrimarySheet();
        this.createPreviewContents(this.previewWorkbook, sheet);
        this.previewer.setInput((Object)new MindMap(sheet));
        return this.previewer.getControl();
    }

    protected void addExtraCapacityForPreview(MindMapViewer previewer) {
    }

    protected IWorkbook getPreviewWorbook() {
        return this.previewWorkbook;
    }

    private void createPreviewContents(IWorkbook workbook, ISheet sheet) {
        ITopic rootTopic = sheet.getRootTopic();
        rootTopic.setTitleText(MindMapMessages.TitleText_CentralTopic);
        rootTopic.setStructureClass("org.xmind.ui.map.clockwise");
        ITopic mainTopic1 = workbook.createTopic();
        mainTopic1.setTitleText(NLS.bind((String)MindMapMessages.TitleText_MainTopic, (Object)1));
        rootTopic.add(mainTopic1);
        ITopic mainTopic2 = workbook.createTopic();
        mainTopic2.setTitleText(NLS.bind((String)MindMapMessages.TitleText_MainTopic, (Object)2));
        rootTopic.add(mainTopic2);
        ITopic callout = workbook.createTopic();
        callout.setTitleText(MindMapMessages.TitleText_CalloutTopic);
        mainTopic2.add(callout, "callout");
        ITopic subTopic1 = workbook.createTopic();
        subTopic1.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)1));
        mainTopic1.add(subTopic1);
        ITopic subTopic2 = workbook.createTopic();
        subTopic2.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)2));
        mainTopic1.add(subTopic2);
        ITopic subTopic3 = workbook.createTopic();
        subTopic3.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)3));
        mainTopic1.add(subTopic3);
        ITopic subTopic4 = workbook.createTopic();
        subTopic4.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)4));
        mainTopic2.add(subTopic4);
        ITopic subTopic5 = workbook.createTopic();
        subTopic5.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)5));
        mainTopic2.add(subTopic5);
        ITopic subTopic6 = workbook.createTopic();
        subTopic6.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)6));
        mainTopic2.add(subTopic6);
        ITopic floatingTopic = workbook.createTopic();
        floatingTopic.setTitleText(MindMapMessages.TitleText_FloatingTopic);
        floatingTopic.setPosition(0, -120);
        rootTopic.add(floatingTopic, "detached");
        IBoundary boundary = workbook.createBoundary();
        boundary.setTitleText(MindMapMessages.TitleText_Boundary);
        boundary.setStartIndex(0);
        boundary.setEndIndex(0);
        rootTopic.addBoundary(boundary);
        IRelationship relationship = workbook.createRelationship();
        relationship.setTitleText(MindMapMessages.TitleText_Relationship);
        relationship.setEnd1Id(mainTopic1.getId());
        relationship.setEnd2Id(floatingTopic.getId());
        IControlPoint cp1 = relationship.getControlPoint(0);
        cp1.setPosition(50, -100);
        IControlPoint cp2 = relationship.getControlPoint(1);
        cp2.setPosition(100, 0);
        sheet.addRelationship(relationship);
        ISummary summary = workbook.createSummary();
        summary.setStartIndex(0);
        summary.setEndIndex(3);
        mainTopic2.addSummary(summary);
        ITopic summaryTopic = workbook.createTopic();
        summaryTopic.setTitleText(MindMapMessages.TitleText_SummaryTopic);
        mainTopic2.add(summaryTopic, "summary");
        summary.setTopicId(summaryTopic.getId());
        ITopic subTopic1ForSummary = workbook.createTopic();
        subTopic1ForSummary.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)1));
        summaryTopic.add(subTopic1ForSummary);
        ITopic subTopic2ForSummary = workbook.createTopic();
        subTopic2ForSummary.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)2));
        summaryTopic.add(subTopic2ForSummary);
        ITopic subTopic3ForSummary = workbook.createTopic();
        subTopic3ForSummary.setTitleText(NLS.bind((String)MindMapMessages.TitleText_Subtopic, (Object)3));
        summaryTopic.add(subTopic3ForSummary);
        this.previewStyleds = new ArrayList<IStyled>();
        this.previewStyleds.add((IStyled)rootTopic);
        this.previewStyleds.add((IStyled)mainTopic1);
        this.previewStyleds.add((IStyled)mainTopic2);
        this.previewStyleds.add((IStyled)callout);
        this.previewStyleds.add((IStyled)subTopic1);
        this.previewStyleds.add((IStyled)subTopic2);
        this.previewStyleds.add((IStyled)subTopic3);
        this.previewStyleds.add((IStyled)subTopic4);
        this.previewStyleds.add((IStyled)subTopic5);
        this.previewStyleds.add((IStyled)subTopic6);
        this.previewStyleds.add((IStyled)subTopic1ForSummary);
        this.previewStyleds.add((IStyled)subTopic2ForSummary);
        this.previewStyleds.add((IStyled)subTopic3ForSummary);
        this.previewStyleds.add((IStyled)floatingTopic);
        this.previewStyleds.add((IStyled)summaryTopic);
        this.previewStyleds.add((IStyled)summary);
        this.previewStyleds.add((IStyled)boundary);
        this.previewStyleds.add((IStyled)relationship);
        this.previewStyleds.add((IStyled)sheet);
    }

    private void createPopupMenu() {
        MenuManager menu = new MenuManager("#PopupMenu");
        menu.add((IContributionItem)new Separator(GROUP_FILE));
        menu.add((IContributionItem)new Separator(GROUP_OPEN));
        menu.add((IContributionItem)new GroupMarker(GROUP_SHOW_IN));
        menu.add((IContributionItem)new Separator(GROUP_EDIT));
        menu.add((IContributionItem)new Separator(GROUP_REORGANIZE));
        menu.add((IContributionItem)new Separator(GROUP_GENERATE));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator(GROUP_PROPERTIES));
        IMenuService menuService = (IMenuService)this.parentWindow.getWorkbench().getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)menu, "popup:org.xmind.ui.StyleEditor");
        this.editor.setPopupMenu(menu.createContextMenu(this.editor.getControl()));
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = StyleEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(SETTINGS_SECTION);
        }
        return section;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ((GridLayout)parent.getLayout()).makeColumnsEqualWidth = false;
        this.createButton(parent, 0, StyleEditorMessages.StyleEditorDialog_SaveAsNewStyle_buttonText, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(StyleEditorMessages.StyleEditorDialog_text);
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent e) {
                StyleEditorDialog.this.deactivateHandlers();
                StyleEditorDialog.this.deactivateContext();
            }

            public void shellClosed(ShellEvent e) {
                StyleEditorDialog.this.deactivateHandlers();
                StyleEditorDialog.this.deactivateContext();
            }

            public void shellActivated(ShellEvent e) {
                StyleEditorDialog.this.activateContext();
                StyleEditorDialog.this.activateHandlers();
            }
        });
    }

    private void activateHandlers() {
        IHandlerService handlerService;
        if (this.currentSelectionProviderWrap != null) {
            this.currentSelectionProviderWrap.notifySelectionChanges();
        }
        if ((handlerService = (IHandlerService)this.parentWindow.getWorkbench().getService(IHandlerService.class)) == null) {
            return;
        }
        if (this.undoAction == null) {
            this.undoAction = new UndoStylePropertyChangeAction();
        }
        this.undoAction.setModel(this.getModel());
        this.handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.undo", (IHandler)new ActionHandler((IAction)this.undoAction)));
        if (this.redoAction == null) {
            this.redoAction = new RedoStylePropertyChangeAction();
        }
        this.redoAction.setModel(this.getModel());
        this.handlerActivations.add(handlerService.activateHandler("org.eclipse.ui.edit.redo", (IHandler)new ActionHandler((IAction)this.redoAction)));
    }

    private void deactivateHandlers() {
        IHandlerService handlerService;
        if (this.redoAction != null) {
            this.redoAction.setModel(null);
            this.redoAction = null;
        }
        if (this.undoAction != null) {
            this.undoAction.setModel(null);
            this.undoAction = null;
        }
        if ((handlerService = (IHandlerService)this.parentWindow.getWorkbench().getService(IHandlerService.class)) == null) {
            return;
        }
        handlerService.deactivateHandlers(this.handlerActivations);
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.parentWindow.getWorkbench().getService(IContextService.class);
        if (contextService == null) {
            return;
        }
        this.contextActivation = contextService.activateContext("org.xmind.ui.context.editingStyle");
    }

    private void deactivateContext() {
        IContextService contextService = (IContextService)this.parentWindow.getWorkbench().getService(IContextService.class);
        if (contextService == null) {
            return;
        }
        if (this.contextActivation != null) {
            contextService.deactivateContext(this.contextActivation);
            this.contextActivation = null;
        }
    }

    private void handleDispose() {
        if (this.currentSelectionProviderWrap != null) {
            this.currentSelectionProviderWrap.dispose();
            this.currentSelectionProviderWrap = null;
        }
        this.getModel().removeListener(this.modelListener);
        this.deactivateHandlers();
        this.deactivateContext();
        if (this.previewStorage != null) {
            this.previewStorage.clear();
            this.previewStorage = null;
        }
        if (this.editor != null) {
            this.editor.dispose();
            this.editor = null;
        }
    }

    protected void updatePreview(StyleEditModel model) {
        model.writeStyle(this.previewStyle);
        String type = this.previewStyle.getType();
        String styleId = this.previewStyle.getId();
        for (IStyled styled : this.previewStyleds) {
            styled.setStyleId(null);
            if (!type.equalsIgnoreCase(styled.getStyleType())) continue;
            styled.setStyleId(styleId);
        }
    }

    protected void updateDirtyState() {
        final Button okButton = this.getButton(0);
        if (okButton != null && !okButton.isDisposed()) {
            okButton.getDisplay().syncExec(new Runnable(){

                public void run() {
                    boolean dirty = StyleEditorDialog.this.getModel().isDirty();
                    okButton.setEnabled(dirty);
                    okButton.setText(!StyleEditorDialog.this.isModifiable() ? StyleEditorMessages.StyleEditorDialog_SaveAsNewStyle_buttonText : StyleEditorMessages.StyleEditorDialog_Save_buttonText);
                    StyleEditorDialog.this.getShell().setModified(dirty);
                }
            });
        }
    }

    private boolean isModifiable() {
        IStyleSheet styleSheet = this.inputStyle.getOwnedStyleSheet();
        return styleSheet == MindMapUI.getResourceManager().getUserStyleSheet();
    }

    protected void okPressed() {
        this.saveModel();
        VerifyUI20141031.getUsageDataCollector().increase("EditStyleCount");
        super.okPressed();
    }

    private boolean saveModel() {
        SafeRunner.run((ISafeRunnable)new SafeRunnable(){

            public void run() throws Exception {
                if (StyleEditorDialog.this.isModifiable()) {
                    StyleEditorDialog.this.saveStyle();
                } else {
                    StyleEditorDialog.this.saveAsNewStyle();
                }
            }
        });
        return true;
    }

    private void saveAsNewStyle() {
        this.getModel().clean();
        IStyleSheet styleSheet = MindMapUI.getResourceManager().getUserStyleSheet();
        IStyle styleCreated = styleSheet.importStyle(this.previewStyle);
        styleCreated.setName(StyleEditorMessages.StyleEditorDialog_NewStyle_UntitledName);
        MindMapUI.getResourceManager().saveUserStyleSheet();
        if (this.stylesViewer != null) {
            this.stylesViewer.setSelection((ISelection)new StructuredSelection((Object)styleCreated));
        }
    }

    private void saveStyle() {
        IStyleSheet styleSheet = MindMapUI.getResourceManager().getUserStyleSheet();
        IStyle styleImported = this.inputStyle;
        String styleName = this.inputStyle.getName();
        if (this.model.isDirty()) {
            this.model.clean();
            styleSheet.removeStyle(this.inputStyle);
            styleImported = styleSheet.importStyle(this.previewStyle);
            styleSheet.addStyle(styleImported, "normal-styles");
            styleImported.setName(styleName);
        }
        MindMapUI.getResourceManager().saveUserStyleSheet();
        if (this.stylesViewer != null) {
            this.stylesViewer.setSelection((ISelection)new StructuredSelection((Object)styleImported));
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.closePressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void handleShellCloseEvent() {
        this.closePressed();
    }

    protected void closePressed() {
        if (this.getModel().isDirty()) {
            String message = StyleEditorMessages.StyleEditorDialog_SaveModifiedStyleBeforeClose_warningMessage;
            int decision = new QuestionDialog(this.getShell(), StyleEditorMessages.StyleEditorDialog_dialogTitle, message).open();
            if (decision == 0) {
                this.saveModel();
            } else {
                if (decision == -1 || decision == 2) {
                    return;
                }
                if (decision == 1) {
                    this.getModel().clean();
                }
            }
        }
        IEclipseContext context = ((WorkbenchWindow)this.parentWindow).getModel().getContext();
        context.remove("selection");
        IEvaluationService es = (IEvaluationService)this.parentWindow.getWorkbench().getService(IEvaluationService.class);
        es.getCurrentState().addVariable("selection", (Object)new StructuredSelection((Object)this.inputStyle));
        this.setReturnCode(0);
        this.close();
    }

    private class CurrentSelectionProviderWrap
    implements ISelectionChangedListener {
        private ISelectionProvider selectionProvider = null;

        private CurrentSelectionProviderWrap() {
        }

        public void dispose() {
            if (this.selectionProvider != null) {
                this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
                this.selectionProvider = null;
            }
        }

        public void notifySelectionChanges() {
            IEclipseContext context = ((WorkbenchWindow)StyleEditorDialog.this.parentWindow).getModel().getContext();
            context.remove("selection");
            if (this.selectionProvider != null) {
                IEvaluationService es = (IEvaluationService)StyleEditorDialog.this.parentWindow.getWorkbench().getService(IEvaluationService.class);
                es.getCurrentState().addVariable("selection", (Object)this.selectionProvider.getSelection());
            }
        }

        public void setSelectionProvider(ISelectionProvider selectionProvider) {
            if (selectionProvider == this.selectionProvider) {
                return;
            }
            ISelectionProvider oldSelectionProvider = this.selectionProvider;
            this.selectionProvider = selectionProvider;
            if (oldSelectionProvider != null) {
                oldSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
            if (selectionProvider != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.notifySelectionChanges();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.notifySelectionChanges();
        }
    }

    protected static class QuestionDialog
    extends MessageDialog {
        public static final int ID_YES = 0;
        public static final int ID_NO = 1;
        public static final int ID_CANCEL = 2;
        public static final int ID_CLOSE = -1;

        public QuestionDialog(Shell parentShell, String dialogTitle, String dialogMessage) {
            super(parentShell, dialogTitle, null, dialogMessage, 6, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, -1);
            this.setShellStyle(this.getShellStyle() | 0x10000000);
        }
    }

    private class StyleEditorMindMapViewer
    extends MindMapViewer {
        private StyleEditorMindMapViewer() {
        }

        protected Control internalCreateControl(Composite parent, int style) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new FillLayout());
            container.setLayoutData((Object)new GridData(4, 4, true, true));
            FigureCanvas fc = new FigureCanvas(container, style, this.getLightweightSystem());
            this.addHorizontalScrollSupport(fc);
            fc.setViewport(this.getViewport());
            fc.setScrollBarVisibility(FigureCanvas.ALWAYS);
            fc.setBackground(parent.getDisplay().getSystemColor(1));
            return fc;
        }

        private void addHorizontalScrollSupport(final FigureCanvas canvas) {
            if (Util.isWindows()) {
                canvas.addListener(38, new Listener(){

                    public void handleEvent(Event event) {
                        if (!canvas.isDisposed()) {
                            int offset = event.count;
                            offset = -((int)(Math.sqrt(Math.abs(offset)) * (double)offset));
                            Point viewLocation = canvas.getViewport().getViewLocation();
                            canvas.getViewport().setHorizontalLocation(viewLocation.x + offset);
                        }
                    }
                });
            }
        }
    }
}

