/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.sharing;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.xmind.core.command.ICommand;
import org.xmind.core.command.ICommandHandler;
import org.xmind.core.command.ReturnValue;
import org.xmind.core.command.arguments.ArrayMapper;
import org.xmind.core.command.arguments.Attributes;
import org.xmind.core.internal.sharing.LocalNetworkSharing;
import org.xmind.core.internal.sharing.LocalSharedLibrary;
import org.xmind.core.internal.sharing.LocalSharedMap;
import org.xmind.core.sharing.ILocalSharedLibrary;
import org.xmind.core.sharing.ILocalSharedMap;
import org.xmind.core.sharing.ISharedMap;

public class HandshakeCommandHandler
implements ICommandHandler {
    public IStatus execute(IProgressMonitor monitor, ICommand command, String[] matches) {
        ILocalSharedLibrary localLibrary = LocalNetworkSharing.getDefault().getSharingService().getLocalLibrary();
        Attributes attrs = new Attributes();
        attrs.with("version", "1");
        attrs.with("name", localLibrary.getName());
        attrs.with("contact-id", localLibrary.getContactID());
        ArrayMapper mapsWriter = new ArrayMapper(attrs.getRawMap(), "maps");
        Attributes data = command.getArguments();
        ISharedMap[] iSharedMapArray = localLibrary.getMaps();
        int n = iSharedMapArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISharedMap map = iSharedMapArray[n2];
            String remoteID = data.get("contact-id");
            boolean hasAccessRight = ((ILocalSharedMap)map).hasAccessRight(remoteID);
            if (hasAccessRight) {
                String thumbnail;
                mapsWriter.next();
                mapsWriter.set("id", (Object)map.getID());
                mapsWriter.set("name", (Object)map.getResourceName());
                long modifiedTime = map.getResourceModifiedTime();
                mapsWriter.set("modified-time", (Object)String.valueOf(modifiedTime));
                if (remoteID == null) {
                    thumbnail = ((LocalSharedLibrary)localLibrary).getEncodedXMind2014Thumbnail();
                    mapsWriter.set("thumbnail", (Object)thumbnail);
                    mapsWriter.set("missing", (Object)"true");
                } else {
                    thumbnail = ((LocalSharedMap)map).getEncodedThumbnailData();
                    mapsWriter.set("thumbnail", (Object)thumbnail);
                    mapsWriter.set("missing", (Object)(map.isMissing() ? "true" : "false"));
                }
            }
            ++n2;
        }
        mapsWriter.setSize();
        monitor.done();
        return new ReturnValue("org.xmind.core.sharing", attrs);
    }
}

