/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.xmind.verify.ui.AbstractProViewPart20141031;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.part.PageBook;
import org.xmind.gef.IInputChangedListener;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.editor.IGlobalActionHandlerService;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.mindmap.IMindMap;
import org.xmind.ui.tabfolder.IPageClosedListener;

public class GanttView
extends AbstractProViewPart20141031
implements IPartListener,
IPageChangedListener,
IContributedContentsView,
IPageClosedListener,
IInputChangedListener,
ISelectionChangedListener {
    public static final String GANTT_EDIT_CONTEXT_ID = "org.xmind.ui.context.gantt.edit";
    public static final String TASK_TREE_EDIT_CONTEXT_ID = "org.xmind.ui.context.gantt.taskTreeEdit";
    private Composite parentComposite;
    private IGraphicalEditor sourceEditor;
    private IGraphicalEditorPage sourcePage = null;
    private Map<IGraphicalEditor, Collection<IGraphicalEditorPage>> pages = new HashMap<IGraphicalEditor, Collection<IGraphicalEditorPage>>();
    private Map<IGraphicalEditorPage, GanttViewer> viewers = new HashMap<IGraphicalEditorPage, GanttViewer>();
    private PageBook viewerStack = null;
    private GanttViewer currentViewer = null;
    private Composite defaultPage = null;
    private ISelectionProvider selectionProvider;
    private Properties properties;

    protected int getRequiredFeatures() {
        return 3;
    }

    protected String getFeatureKey() {
        return "Gantt";
    }

    protected void doCreatePartControl(Composite parent) {
        this.parentComposite = parent;
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.viewerStack = new PageBook(composite, 0);
        this.viewerStack.setLayoutData((Object)new GridData(4, 4, true, true));
        this.defaultPage = this.createDefaultPage((Composite)this.viewerStack);
        this.getSite().setSelectionProvider(this.getSelectionProvider());
        this.partActivated((IWorkbenchPart)this.getSite().getPage().getActiveEditor());
        this.getSite().getPage().addPartListener((IPartListener)this);
    }

    public void dispose() {
        this.setEditor(null);
        this.getSite().getPage().removePartListener((IPartListener)this);
        Object[] objectArray = this.pages.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object editor = objectArray[n2];
            this.partClosed((IWorkbenchPart)((IGraphicalEditor)editor));
            ++n2;
        }
        super.dispose();
    }

    private Composite createDefaultPage(Composite parent) {
        Composite page = new Composite(parent, 0);
        page.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(page, 16448);
        label.setText(GanttMessages.GanttView_DefaultText);
        label.setLayoutData((Object)new GridData(4, 4, true, true));
        return page;
    }

    private void setEditor(IGraphicalEditor editor) {
        ISelectionProvider selectionProvider;
        IGlobalActionHandlerService actionService;
        if (editor == this.sourceEditor) {
            return;
        }
        if (this.sourceEditor != null) {
            this.sourceEditor.removePageChangedListener((IPageChangedListener)this);
            actionService = (IGlobalActionHandlerService)this.sourceEditor.getAdapter(IGlobalActionHandlerService.class);
            if (actionService != null) {
                actionService.removeActionBars(this.getViewSite().getActionBars());
            }
            if ((selectionProvider = this.sourceEditor.getSite().getSelectionProvider()) != null) {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
        this.sourceEditor = editor;
        if (this.sourceEditor != null) {
            this.sourceEditor.addPageChangedListener((IPageChangedListener)this);
            actionService = (IGlobalActionHandlerService)this.sourceEditor.getAdapter(IGlobalActionHandlerService.class);
            if (actionService != null) {
                actionService.addActionBars(this.getViewSite().getActionBars());
            }
            this.setSourcePage(this.sourceEditor.getActivePageInstance());
            selectionProvider = this.sourceEditor.getSite().getSelectionProvider();
            if (selectionProvider != null) {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
                this.getSelectionProvider().setSelection(selectionProvider.getSelection());
            }
        } else {
            this.setSourcePage(null);
        }
    }

    private void setSourcePage(IGraphicalEditorPage page) {
        if (page == this.sourcePage) {
            return;
        }
        this.sourcePage = page;
        GanttViewer newViewer = null;
        if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            GanttViewer viewer;
            Composite pageToShow = this.defaultPage;
            this.currentViewer = null;
            if (this.sourcePage != null && (viewer = this.ensureGanttViewer(this.sourcePage)) != null && !viewer.getControl().isDisposed()) {
                this.currentViewer = viewer;
                pageToShow = viewer.getControl();
                newViewer = viewer;
            }
            this.viewerStack.showPage((Control)pageToShow);
        }
        this.viewerChanged(newViewer);
    }

    private void viewerChanged(GanttViewer viewer) {
    }

    private void registerSourcePage(IGraphicalEditorPage page) {
        IGraphicalEditor editor = page.getParentEditor();
        Collection<IGraphicalEditorPage> list = this.pages.get(editor);
        if (list == null) {
            list = new HashSet<IGraphicalEditorPage>();
            this.pages.put(editor, list);
        }
        list.add(page);
    }

    private void unregisterSourcePage(IGraphicalEditorPage page) {
        IGraphicalEditor editor = page.getParentEditor();
        Collection<IGraphicalEditorPage> list = this.pages.get(editor);
        if (list != null) {
            list.remove(page);
            if (list.isEmpty()) {
                this.pages.remove(editor);
            }
        }
    }

    private GanttViewer ensureGanttViewer(IGraphicalEditorPage page) {
        IMindMap map;
        GanttViewer viewer = this.getViewer(this.sourcePage);
        if (viewer == null && (map = (IMindMap)this.sourcePage.getAdapter(IMindMap.class)) != null) {
            viewer = this.createGanttViewer((Composite)this.viewerStack, map.getCentralTopic(), page);
            this.registerSourcePage(page);
            this.registerViewer(page, viewer);
        }
        return viewer;
    }

    private void registerViewer(IGraphicalEditorPage page, GanttViewer viewer) {
        this.viewers.put(page, viewer);
        viewer.getSelectionSynchronizer().addPrimary(page.getSelectionProvider());
        page.getViewer().addInputChangedListener((IInputChangedListener)this);
    }

    private void unregisterViewer(IGraphicalEditorPage page, GanttViewer viewer) {
        if (page != null) {
            page.getViewer().removeInputChangedListener((IInputChangedListener)this);
        }
        if (viewer != null) {
            viewer.getSelectionSynchronizer().remove(page.getSelectionProvider());
        }
        this.viewers.remove(page);
    }

    private GanttViewer getViewer(IGraphicalEditorPage page) {
        return this.viewers.get(page);
    }

    private GanttViewer createGanttViewer(Composite parent, Object input, IGraphicalEditorPage sourcePage) {
        GanttViewer viewer = new GanttViewer();
        viewer.setCommandStack(sourcePage.getEditDomain().getCommandStack());
        viewer.createControl(parent);
        viewer.setInput(input);
        return viewer;
    }

    private void disposeGanttViewer(GanttViewer viewer) {
        if (viewer != null && viewer.getControl() != null) {
            viewer.getControl().dispose();
        }
    }

    protected void doSetFocus() {
        if (this.currentViewer != null && !this.currentViewer.getControl().isDisposed()) {
            this.currentViewer.setFocus();
        } else if (this.viewerStack != null && !this.viewerStack.isDisposed()) {
            this.viewerStack.setFocus();
        } else if (this.parentComposite != null && !this.parentComposite.isDisposed()) {
            this.parentComposite.setFocus();
        }
    }

    public void partActivated(final IWorkbenchPart part) {
        if (!(part instanceof IGraphicalEditor)) {
            return;
        }
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                GanttView.this.setEditor((IGraphicalEditor)part);
            }
        });
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        Collection<IGraphicalEditorPage> oldPages = this.pages.remove(part);
        if (part == this.sourceEditor) {
            this.setEditor(null);
        }
        if (oldPages != null) {
            Object[] objectArray = oldPages.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object page = objectArray[n2];
                this.pageClosed(page);
                ++n2;
            }
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void pageChanged(PageChangedEvent event) {
        final IGraphicalEditorPage page = (IGraphicalEditorPage)event.getSelectedPage();
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (page.isDisposed() || page.getControl() == null || page.getControl().isDisposed()) {
                    return;
                }
                GanttView.this.setSourcePage(page);
            }
        });
    }

    public void pageClosed(Object pageObject) {
        if (pageObject instanceof IGraphicalEditorPage) {
            IGraphicalEditorPage page = (IGraphicalEditorPage)pageObject;
            this.unregisterSourcePage(page);
            GanttViewer viewer = this.getViewer(page);
            this.unregisterViewer(page, viewer);
            this.disposeGanttViewer(viewer);
        }
    }

    public IWorkbenchPart getContributingPart() {
        return this.sourceEditor;
    }

    public void inputChanged(IViewer viewer, Object newInput, Object oldInput) {
        IMindMap map;
        GanttViewer ganttViewer;
        IGraphicalEditorPage page = (IGraphicalEditorPage)viewer.getProperties().get("editorPage");
        if (page != null && (ganttViewer = this.getViewer(page)) != null && (map = (IMindMap)page.getAdapter(IMindMap.class)) != null) {
            ganttViewer.setInput(map.getCentralTopic());
        }
    }

    public GanttViewer getCurrentViewer() {
        return this.currentViewer;
    }

    public ISelectionProvider getSelectionProvider() {
        if (this.selectionProvider == null) {
            this.selectionProvider = new SelectionProvider();
        }
        return this.selectionProvider;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.getSelectionProvider().setSelection(selection);
    }

    public void activateGlobalActionHandlers() {
        IGlobalActionHandlerService actionService;
        if (this.sourceEditor != null && (actionService = (IGlobalActionHandlerService)this.sourceEditor.getAdapter(IGlobalActionHandlerService.class)) != null) {
            actionService.addActionBars(this.getViewSite().getActionBars());
        }
    }

    public void deactivateGlobalActionHanlders() {
        IGlobalActionHandlerService actionService;
        if (this.sourceEditor != null && (actionService = (IGlobalActionHandlerService)this.sourceEditor.getAdapter(IGlobalActionHandlerService.class)) != null) {
            actionService.removeActionBars(this.getViewSite().getActionBars());
        }
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    private class SelectionProvider
    implements ISelectionProvider {
        private List<ISelectionChangedListener> selectionChangedListeners = null;
        private ISelection selection;

        private SelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionChangedListeners == null) {
                this.selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
            }
            this.selectionChangedListeners.add(listener);
        }

        public ISelection getSelection() {
            return this.selection == null ? StructuredSelection.EMPTY : this.selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            if (this.selectionChangedListeners == null) {
                return;
            }
            this.selectionChangedListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
            if (this.selection == selection) {
                return;
            }
            this.selection = selection;
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }

        private void fireSelectionChanged(SelectionChangedEvent event) {
            if (this.selectionChangedListeners == null) {
                return;
            }
            Object[] objectArray = this.selectionChangedListeners.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                ((ISelectionChangedListener)o).selectionChanged(event);
                ++n2;
            }
        }
    }
}

