/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.printing.PrintDialog;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.xmind.core.ITopic;
import org.xmind.gef.IEditDomainListener;
import org.xmind.gef.command.ICommandStack;
import org.xmind.gef.part.IPart;
import org.xmind.gef.tool.ITool;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt.GanttPlugin;
import org.xmind.ui.gantt.export.ExportToImageWizard;
import org.xmind.ui.gantt.export.ExportToPdfWizard;
import org.xmind.ui.gantt.export.GanttPrintClient;
import org.xmind.ui.gantt.export.PrintGanttSetupDialog;
import org.xmind.ui.gantt2.gefext.GraphicalViewer2;
import org.xmind.ui.gantt2.gefext.IEditPart;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.GanttEditDomain;
import org.xmind.ui.gantt2.viewer.IFoldingStatusChangeListener;
import org.xmind.ui.gantt2.viewer.ScrollingSynchronizer;
import org.xmind.ui.gantt2.viewer.TaskBarViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeHeaderViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeWidthsSupport;
import org.xmind.ui.gantt2.viewer.TimelineController;
import org.xmind.ui.gantt2.viewer.TimelineViewer;
import org.xmind.ui.internal.aspose.exports.project.ProjectExportWizard;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.viewers.SelectionSynchronizer;

public class GanttViewer
implements IFoldingStatusChangeListener,
DisposeListener,
ISelectionChangedListener,
IEditDomainListener {
    public static final int DEFAULT_HEADER_HEIGHT = (int)(0.20833333333333334 * (double)Display.getCurrent().getDPI().y) + 20;
    private static final int DEFAULT_SIDEBAR_WIDTH = 250;
    private static final int MIN_SIDEBAR_WIDTH = 100;
    private static final int SPLIT_BAR_WIDTH = 2;
    private static final int MINI_BAR_HEIGHT = 28;
    private Object input = null;
    private Composite chrome = null;
    private SplitLayout chromeLayout = null;
    private TaskTreeHeaderViewer headerViewer = null;
    private TimelineController timelineController = null;
    private TimelineViewer timelineViewer = null;
    private TaskTreeViewer taskTreeViewer = null;
    private TaskBarViewer taskBarViewer = null;
    private SplitBar splitBar = null;
    private GanttEditDomain editDomain = new GanttEditDomain(this);
    private ScrollingSynchronizer verticalScrollSynchronizer = new ScrollingSynchronizer(false);
    private ScrollingSynchronizer horizontalScrollSynchronizer = new ScrollingSynchronizer(true);
    private SelectionSynchronizer selectionSynchronizer = new SelectionSynchronizer();
    private TaskTreeWidthsSupport widthsSupport;
    private IContextActivation contextActivation;
    private IContextService contextService;
    private Properties properties;
    private ResourceManager resources;

    public GanttViewer() {
        this.editDomain.getConfigurations().addFoldingStatusChangeListener(this);
        this.editDomain.addEditDomainListener(this);
    }

    public GanttEditDomain getEditDomain() {
        return this.editDomain;
    }

    public void setCommandStack(ICommandStack commandStack) {
        this.editDomain.setCommandStack(commandStack);
    }

    public Control getControl() {
        return this.chrome;
    }

    public Control createControl(Composite parent) {
        this.resources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        if (this.chrome != null && !this.chrome.isDisposed()) {
            return this.chrome;
        }
        this.chrome = new Composite(parent, 0);
        this.chromeLayout = new SplitLayout();
        this.chromeLayout.hSplitWidth = 2;
        this.chromeLayout.hSplitPosition = 250;
        this.chromeLayout.vSplitPosition = DEFAULT_HEADER_HEIGHT;
        this.chrome.setLayout((Layout)this.chromeLayout);
        this.chrome.addDisposeListener((DisposeListener)this);
        this.widthsSupport = new TaskTreeWidthsSupport();
        this.chrome.setBackground(Colors.header());
        this.createTaskTreeHeaderViewer(this.chrome, this.widthsSupport);
        this.createSplitbar(this.chrome);
        this.createTimelineViewer(this.chrome);
        this.chrome.setBackground(parent.getDisplay().getSystemColor(1));
        this.createTaskTreeViewer(this.chrome, this.widthsSupport);
        this.createTaskBarViewer(this.chrome);
        this.createMiniBar(this.chrome);
        this.expandHorizontalSynScroll();
        return this.chrome;
    }

    private void createTaskTreeHeaderViewer(Composite parent, TaskTreeWidthsSupport widthsSupport) {
        Control control;
        this.headerViewer = new TaskTreeHeaderViewer(widthsSupport);
        this.horizontalScrollSynchronizer.add(this.headerViewer.getViewport());
        this.headerViewer.setGanttViewer(this);
        this.chromeLayout.topLeft = control = this.headerViewer.createControl(parent, Colors.header());
    }

    private void createTimelineViewer(Composite parent) {
        this.timelineViewer = new TimelineViewer();
        this.timelineViewer.setEditDomain(this.editDomain);
        this.timelineViewer.createControl(parent);
        this.timelineViewer.getControl().setBackground(Colors.timeline());
        this.chromeLayout.topRight = this.timelineViewer.getControl();
    }

    private void createTaskTreeViewer(Composite parent, TaskTreeWidthsSupport widthsSupport) {
        this.taskTreeViewer = new TaskTreeViewer(widthsSupport, this);
        this.taskTreeViewer.setEditDomain(this.editDomain);
        this.taskTreeViewer.addPreSelectionChangedListener(this);
        this.taskTreeViewer.createControl(parent);
        this.taskTreeViewer.getControl().setBackground(parent.getBackground());
        this.verticalScrollSynchronizer.add(this.taskTreeViewer);
        this.horizontalScrollSynchronizer.add(this.taskTreeViewer);
        this.selectionSynchronizer.add((ISelectionProvider)this.taskTreeViewer);
        this.chromeLayout.bottomLeft = this.taskTreeViewer.getControl();
    }

    private void createTaskBarViewer(Composite parent) {
        this.taskBarViewer = new TaskBarViewer();
        this.taskBarViewer.setEditDomain(this.editDomain);
        this.taskBarViewer.addPreSelectionChangedListener(this);
        this.taskBarViewer.createControl(parent);
        this.taskBarViewer.getControl().setBackground(parent.getBackground());
        this.verticalScrollSynchronizer.add(this.taskBarViewer);
        this.selectionSynchronizer.add((ISelectionProvider)this.taskBarViewer);
        this.chromeLayout.bottomRight = this.taskBarViewer.getControl();
    }

    private void createSplitbar(Composite parent) {
        this.splitBar = new SplitBar(parent, 0);
        this.splitBar.getControl().setBackground(parent.getBackground());
        this.chromeLayout.hSplit = this.splitBar.getControl();
    }

    private void createMiniBar(Composite parent) {
        Composite miniBar = new Composite(parent, 2048);
        miniBar.setBackground(parent.getDisplay().getSystemColor(22));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 3;
        miniBar.setLayout((Layout)layout);
        miniBar.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTimelineController(miniBar);
        this.chromeLayout.miniBar = miniBar;
    }

    private void createExportController(final Composite parent) {
        final Label label = new Label(parent, 0);
        label.setImage(this.resources.createImage(GanttViewer.getImageDescriptor("export.png")));
        label.setCursor(label.getDisplay().getSystemCursor(21));
        final GanttViewer viewer = this;
        final MenuManager menu = new MenuManager();
        menu.add((IAction)new Action(GanttMessages.GanttViewer_Menu_Export_To_Project){

            public void run() {
                ProjectExportWizard wizard = new ProjectExportWizard();
                wizard.init(GanttPlugin.getDefault().getWorkbench(), null);
                VerifyUI20141031.getUsageDataCollector().increase("ExportGanttToImageCount");
                new WizardDialog(parent.getShell(), (IWizard)wizard).open();
            }
        });
        menu.add((IAction)new Action(GanttMessages.GanttViewer_Menu_Export_To_PDF){

            public void run() {
                ExportToPdfWizard wizard = new ExportToPdfWizard(viewer);
                wizard.init(GanttPlugin.getDefault().getWorkbench(), null);
                VerifyUI20141031.getUsageDataCollector().increase("ExportGanttToPDFCount");
                new WizardDialog(parent.getShell(), (IWizard)wizard).open();
            }
        });
        menu.add((IAction)new Action(GanttMessages.GanttViewer_Export_To_Image){

            public void run() {
                ExportToImageWizard wizard = new ExportToImageWizard(viewer);
                wizard.init(GanttPlugin.getDefault().getWorkbench(), null);
                new WizardDialog(parent.getShell(), (IWizard)wizard).open();
            }
        });
        menu.add((IAction)new Action(GanttMessages.GanttViewer_Menu_Print){

            public void run() {
                VerifyUI20141031.runAction20141031((String)"PrintGantt", (String)GanttMessages.PrintGanttChart_ActionName, (int)3, (Runnable)new Runnable(){

                    public void run() {
                        VerifyUI20141031.getUsageDataCollector().increase("PrintGanttChartCount");
                        this.print(viewer, parent.getShell());
                    }
                }, null);
            }

            private void print(GanttViewer viewer2, Shell parentShell) {
                PrintGanttSetupDialog setupDialog = new PrintGanttSetupDialog(parentShell, viewer2);
                int open = setupDialog.open();
                if (open == 1) {
                    return;
                }
                IDialogSettings settings = setupDialog.getSettings();
                PrinterData printerData = new PrinterData();
                try {
                    printerData.orientation = settings.getInt("orientation");
                }
                catch (NumberFormatException numberFormatException) {
                    printerData.orientation = 2;
                }
                PrintDialog printDialog = new PrintDialog(parentShell);
                printDialog.setPrinterData(printerData);
                printerData = printDialog.open();
                if (printerData != null) {
                    GanttPrintClient client = new GanttPrintClient(GanttMessages.PrintGanttChart_jobName, parentShell, printerData, settings, viewer2);
                    try {
                        client.print();
                    }
                    finally {
                        client.dispose();
                    }
                }
            }
        });
        menu.createContextMenu((Control)label);
        label.setMenu(menu.getMenu());
        label.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                Point loc = label.toDisplay(e.x, e.y);
                menu.getMenu().setLocation(loc);
                menu.getMenu().setVisible(true);
            }
        });
    }

    private void createTimelineController(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(parent.getBackground());
        GridData gridData = new GridData(131072, 0x1000000, true, true);
        gridData.verticalIndent = 1;
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.timelineController = new TimelineController(composite);
        this.timelineController.setBackground(composite.getBackground());
        this.timelineController.setModel(this.getEditDomain().getTimelineModel());
        Control control = this.timelineController.getControl();
        GridData gridData2 = new GridData(4, 4, true, true);
        gridData2.minimumWidth = 140;
        control.setLayoutData((Object)gridData2);
        this.createExportController(composite);
    }

    private void expandHorizontalSynScroll() {
        this.taskTreeViewer.getCanvas().getViewport().getHorizontalRangeModel().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                GanttViewer.this.headerViewer.getCanvas().layout();
            }
        });
    }

    public Object getInput() {
        return this.input;
    }

    public void setInput(Object newInput) {
        if (newInput == this.input) {
            return;
        }
        this.input = newInput;
        if (this.taskTreeViewer != null) {
            this.taskTreeViewer.setInput(this.input);
        }
        if (this.taskBarViewer != null) {
            this.taskBarViewer.setInput(this.input);
        }
        if (this.timelineViewer != null) {
            this.timelineViewer.setInput(this.taskBarViewer);
        }
    }

    private void setSidebarWidth(int value) {
        int maxWidth = this.chrome.getBounds().width;
        this.chromeLayout.hSplitPosition = value = Math.min(Math.max(value, 100), maxWidth - 100);
        this.chrome.layout(true);
    }

    public void setFocus() {
        if (this.taskBarViewer != null && this.taskBarViewer.getControl() != null && !this.taskBarViewer.getControl().isDisposed()) {
            this.taskBarViewer.getControl().setFocus();
        }
    }

    public void foldingStatusChanged(ITopic task, boolean folded) {
        IPart part = this.taskTreeViewer.findPart(task);
        if (part != null) {
            this.updateFoldedStatus(part);
        }
        if ((part = this.taskBarViewer.findPart(task)) != null) {
            this.updateFoldedStatus(part);
        }
    }

    private void updateFoldedStatus(IPart part) {
        if (part instanceof IEditPart) {
            ((IEditPart)part).update("topicFolded");
        } else {
            part.update();
        }
    }

    public final void widgetDisposed(DisposeEvent e) {
        this.handleDisposed();
    }

    protected void handleDisposed() {
        if (this.editDomain != null) {
            this.editDomain.dispose();
            this.editDomain = null;
        }
        this.selectionSynchronizer.clear();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object element = event.getSelection() instanceof IStructuredSelection ? ((IStructuredSelection)event.getSelection()).getFirstElement() : null;
        GraphicalViewer2 viewer = event.getSource() == this.taskTreeViewer ? this.taskBarViewer : this.taskTreeViewer;
        viewer.setPreselected(element);
    }

    public SelectionSynchronizer getSelectionSynchronizer() {
        return this.selectionSynchronizer;
    }

    public TimelineViewer getTimelineViewer() {
        return this.timelineViewer;
    }

    public TaskBarViewer getTaskBarViewer() {
        return this.taskBarViewer;
    }

    public TaskTreeViewer getTaskTreeViewer() {
        return this.taskTreeViewer;
    }

    public TimelineController getTimelineController() {
        return this.timelineController;
    }

    public TaskTreeHeaderViewer getTaskTreeHeaderViewer() {
        return this.headerViewer;
    }

    public TaskTreeWidthsSupport getWidthsSupport() {
        return this.widthsSupport;
    }

    public void activeToolChanged(ITool oldTool, ITool newTool) {
        this.changeContext(newTool);
    }

    protected void changeContext(ITool newTool) {
        this.deactivateContext();
        this.activateContext(newTool == null ? null : newTool.getContextId());
    }

    private void activateContext(String contextId) {
        if (contextId == null) {
            return;
        }
        if (this.contextService == null) {
            this.contextService = this.getContextService();
        }
        if (this.contextService != null) {
            this.contextActivation = this.contextService.activateContext(contextId);
        }
    }

    private IContextService getContextService() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        MPart part = E4Utils.findPart((IWorkbenchWindow)window, (String)"org.xmind.ui.dialogPart.gantt");
        if (part == null) {
            return null;
        }
        IContextService contextService = (IContextService)window.getService(IContextService.class);
        return contextService;
    }

    private void deactivateContext() {
        if (this.contextService != null && this.contextActivation != null) {
            this.contextService.deactivateContext(this.contextActivation);
        }
        this.contextService = null;
        this.contextActivation = null;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        URL url;
        try {
            url = new URL("platform:/plugin/org.xmind.ui.gantt/$nl$/icons/" + path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        URL locatedURL = FileLocator.find((URL)url);
        if (locatedURL != null) {
            url = locatedURL;
        }
        return ImageDescriptor.createFromURL((URL)url);
    }

    private class SplitBar
    implements Listener {
        private Control control;
        private Point start = null;
        private int startingValue = 0;

        public SplitBar(Composite parent, int style) {
            this.control = new Composite(parent, style);
            this.hook(this.control);
        }

        public Control getControl() {
            return this.control;
        }

        private void hook(Control control) {
            control.setCursor(control.getDisplay().getSystemCursor(9));
            control.addListener(9, (Listener)this);
            control.addListener(3, (Listener)this);
            control.addListener(5, (Listener)this);
            control.addListener(4, (Listener)this);
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 9: {
                    this.paintControl(event);
                    break;
                }
                case 3: {
                    this.handleMouseDown(event);
                    break;
                }
                case 5: {
                    this.handleMouseMove(event);
                    break;
                }
                case 4: {
                    this.handleMouseUp(event);
                }
            }
        }

        private void paintControl(Event e) {
            Rectangle r = ((Control)e.widget).getBounds();
            r.x = 0;
            r.y = 0;
            Color oldFG = e.gc.getForeground();
            Color oldBG = e.gc.getBackground();
            e.gc.setBackground(Colors.header());
            e.gc.fillRectangle(r.x, r.y, r.width, DEFAULT_HEADER_HEIGHT);
            e.gc.setForeground(Colors.splitBar());
            int right = r.x + r.width - 1;
            e.gc.drawLine(right, r.y, right, r.y + r.height);
            e.gc.setForeground(oldFG);
            e.gc.setBackground(oldBG);
        }

        private void handleMouseDown(Event e) {
            this.start = this.getCursorPosition(e);
            this.startingValue = this.getSidebarWidth();
        }

        private int getSidebarWidth() {
            return ((GanttViewer)GanttViewer.this).taskTreeViewer.getControl().getBounds().width;
        }

        private void handleMouseUp(Event e) {
            this.start = null;
        }

        private void handleMouseMove(Event e) {
            if (this.start == null) {
                return;
            }
            Point p = this.getCursorPosition(e);
            int sideBarWidth = this.startingValue + p.x - this.start.x;
            if (sideBarWidth > GanttViewer.this.widthsSupport.sum() + 10) {
                GanttViewer.this.setSidebarWidth(GanttViewer.this.widthsSupport.sum() + 10);
            } else {
                GanttViewer.this.setSidebarWidth(this.startingValue + p.x - this.start.x);
            }
        }

        private Point getCursorPosition(Event e) {
            return ((Control)e.widget).toDisplay(e.x, e.y);
        }
    }

    private static class SplitLayout
    extends Layout {
        public Control topLeft;
        public Control topRight;
        public Control bottomLeft;
        public Control bottomRight;
        public Control hSplit;
        public Control miniBar;
        public int hSplitPosition;
        public int hSplitWidth;
        public int vSplitPosition;

        private SplitLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint < 0) {
                wHint = this.hSplitPosition + 400;
            }
            if (hHint < 0) {
                hHint = this.vSplitPosition + 300;
            }
            return new Point(wHint, hHint);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle area = composite.getClientArea();
            int x1 = area.x;
            int y1 = area.y;
            int w1 = this.hSplitPosition;
            int h1 = this.vSplitPosition;
            int x2 = x1 + w1 + this.hSplitWidth;
            int y2 = y1 + h1;
            int w2 = area.width - w1 - this.hSplitWidth;
            int h2 = area.height - h1 - 28;
            if (this.topLeft != null) {
                this.topLeft.setBounds(x1, y1, w1, h1);
            }
            if (this.topRight != null) {
                this.topRight.setBounds(x2, y1, w2, h1);
            }
            if (this.bottomLeft != null) {
                this.bottomLeft.setBounds(x1, y2, w1, h2);
            }
            if (this.bottomRight != null) {
                this.bottomRight.setBounds(x2, y2, w2, h2);
            }
            if (this.hSplit != null) {
                this.hSplit.setBounds(x1 + w1, y1, this.hSplitWidth, h1 + h2);
            }
            if (this.miniBar != null) {
                this.miniBar.setBounds(x1, h1 + h2, area.width, 28);
            }
        }
    }
}

