/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.Calendar;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.resources.ColorUtils;

public class HoursBackgroundFigure
extends Figure {
    private static final int WIDTH = 25;
    private TimelineModel timelineModel;
    private Calendar currentStartCalendar;
    private Calendar currentEndCalendar;
    private boolean isWholeStart;
    private boolean isWholeEnd;
    private int height;

    public HoursBackgroundFigure(TimelineModel timelineModel, Calendar currentStartCalendar, Calendar currentEndCalendar, boolean isWholeStart, boolean isWholeEnd, int height) {
        this.timelineModel = timelineModel;
        this.currentStartCalendar = (Calendar)currentStartCalendar.clone();
        this.currentEndCalendar = (Calendar)currentEndCalendar.clone();
        this.isWholeStart = isWholeStart;
        this.isWholeEnd = isWholeEnd;
        this.height = height;
    }

    protected void paintFigure(Graphics graphics) {
        int startX = this.getXByCalendar(this.currentStartCalendar);
        int endX = this.getXByCalendar(this.currentEndCalendar);
        graphics.setBackgroundColor(ColorUtils.getColor((String)"#f7f7f7"));
        if (this.isWholeStart && this.isWholeEnd) {
            graphics.fillRectangle(startX, 0, 175, this.height);
            graphics.fillRectangle(startX + 175 + 1, 0, 225, this.height);
        } else if (this.isWholeStart && !this.isWholeEnd) {
            if (endX - startX <= 175) {
                graphics.fillRectangle(startX, 0, endX - startX, this.height);
            } else {
                graphics.fillRectangle(startX, 0, 175, this.height);
                if (endX - startX > 176) {
                    graphics.fillRectangle(startX + 175 + 1, 0, endX - startX - 175 - 1, this.height);
                }
            }
        } else if (!this.isWholeStart && this.isWholeEnd) {
            if (endX - startX <= 225) {
                graphics.fillRectangle(startX, 0, endX - startX, this.height);
            } else {
                if (endX - startX > 226) {
                    graphics.fillRectangle(startX, 0, endX - startX - 225, this.height);
                }
                graphics.fillRectangle(endX - 225 + 1, 0, 225, this.height);
            }
        }
    }

    private int getXByCalendar(Calendar calendar) {
        return this.timelineModel.getPixelsFromMillis(calendar.getTimeInMillis() - this.timelineModel.getOriginDate().getTimeInMillis());
    }
}

