/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.ArrayList;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.core.ITopic;
import org.xmind.gef.GEF;
import org.xmind.gef.Request;
import org.xmind.gef.command.Command;
import org.xmind.gef.command.CompoundCommand;
import org.xmind.gef.event.MouseEvent;
import org.xmind.gef.part.IPart;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt2.gefext.AbstractDragTracker;
import org.xmind.ui.gantt2.gefext.HandleFigure;
import org.xmind.ui.gantt2.gefext.ITracker;
import org.xmind.ui.gantt2.gefext.SelectionFeedback;
import org.xmind.ui.gantt2.viewer.Colors;
import org.xmind.ui.gantt2.viewer.TaskBar;
import org.xmind.ui.gantt2.viewer.TaskBarFigure;
import org.xmind.ui.gantt2.viewer.TaskBarPart;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.DurationInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;

public class TaskBarMoveFeedback
extends SelectionFeedback {
    private static final String LOCATION = "location";
    private static final String OFFSET = "offset";
    private static final String LENGTH = "length";
    private static final String START_DATE = "startDate";
    private static final String END_DATE = "endDate";
    private static final String MOVING_START = "movingStart";
    private static final String MOVING_END = "movingEnd";
    private static final String DELTA = "delta";
    private ITracker moveTracker = null;
    private IFigure leftHandle = null;
    private IFigure rightHandle = null;

    public TaskBarPart getHost() {
        return (TaskBarPart)super.getHost();
    }

    protected IFigure getMainFigure() {
        return this.getHost().getBarFigure();
    }

    public boolean containsPoint(Point point) {
        return super.containsPoint(point) || this.isMainFigureAvailable() && this.isOverHandle(point, this.leftHandle, this.rightHandle);
    }

    public ITracker findTracker(Point point) {
        if (this.isMainFigureAvailable() && (this.getMainFigure().containsPoint(point) || this.isOverHandle(point, this.leftHandle, this.rightHandle))) {
            if (this.moveTracker == null) {
                this.moveTracker = new TaskBarMoveTracker();
            }
            return this.moveTracker;
        }
        return null;
    }

    public Cursor findCursor(Point point) {
        if (this.isMainFigureAvailable()) {
            if (this.isOverHandle(point, this.leftHandle, this.rightHandle)) {
                return Cursors.SIZEWE;
            }
            if (this.getMainFigure().containsPoint(point)) {
                return Cursors.HAND;
            }
        }
        return super.findCursor(point);
    }

    public void activate() {
        super.activate();
        this.leftHandle = this.registerHandle((IFigure)new MoveHandleFigure(this.getMainFigure(), true), GEF.LAYER_HANDLE);
        this.rightHandle = this.registerHandle((IFigure)new MoveHandleFigure(this.getMainFigure(), false), GEF.LAYER_HANDLE);
    }

    protected void onPreselected() {
        super.onPreselected();
        this.updateMoveHandles();
    }

    private void updateMoveHandles() {
        if (this.getHost().getStatus().isPreSelected() && this.isMainFigureAvailable() && !this.getHost().getTaskBar().isCheckpoint()) {
            this.activateHandles(this.rightHandle);
            if (this.getMainFigure().getBounds().width < 10) {
                this.deactivateHandles(this.leftHandle);
            } else {
                this.activateHandles(this.leftHandle);
            }
        } else {
            this.deactivateHandles(this.leftHandle, this.rightHandle);
        }
    }

    private boolean isMainFigureAvailable() {
        return this.getMainFigure().isVisible();
    }

    protected void onDepreselected() {
        this.updateMoveHandles();
        super.onDepreselected();
    }

    public void update(Object property) {
        super.update(property);
        this.updateMoveHandles();
    }

    public void showTargetFeedback(Request request) {
        String type = request.getType();
        if ("select".equals(type)) {
            if (this.shouldShowSelectionFeedback(request)) {
                this.showPreSelectionFeedback();
            } else {
                this.hidePreSelectionFeedback();
            }
        } else {
            super.showTargetFeedback(request);
        }
    }

    public void hideTargetFeedback(Request request) {
        String type = request.getType();
        if ("select".equals(type)) {
            this.hidePreSelectionFeedback();
        } else {
            super.hideTargetFeedback(request);
        }
    }

    private boolean shouldShowSelectionFeedback(Request request) {
        Point point = (Point)request.getParameter("position");
        return point == null || this.containsPoint(point);
    }

    private void hidePreSelectionFeedback() {
        this.getHost().removeTooltipRequester(this);
    }

    private void showPreSelectionFeedback() {
        this.getHost().addTooltipRequester(this);
    }

    private static class MoveHandleFigure
    extends HandleFigure {
        private boolean left;

        public MoveHandleFigure(IFigure host, boolean left) {
            this.left = left;
            this.setHost(host);
            this.setBackgroundColor(Colors.moveHandleBackground());
            this.setForegroundColor(Colors.moveHandleBorder());
            this.setOpaque(false);
        }

        protected void calculateBounds(Rectangle source, Rectangle target) {
            target.width = 5;
            target.y = source.y;
            target.height = source.height;
            target.x = this.left ? source.x : source.x + source.width - target.width;
        }

        protected void paintFigure(Graphics graphics) {
            super.paintFigure(graphics);
            Rectangle b = this.getBounds();
            Rectangle r = new Rectangle(b);
            if (!this.left) {
                r.x = r.x + r.width - r.height;
            }
            r.width = r.height;
            graphics.fillRoundRectangle(r, 7, 7);
            graphics.drawRoundRectangle(r.getResized(-1, -1), 7, 7);
            int c = this.left ? b.x + b.width - 1 : b.x;
            graphics.drawLine(c, b.y, c, b.y + b.height);
        }
    }

    private class TaskBarMoveTracker
    extends AbstractDragTracker {
        private TaskBarMoveTracker() {
        }

        public void activate() {
            super.activate();
            TaskBarMoveFeedback.this.getHost().addTooltipRequester(this);
        }

        public void deactivate() {
            TaskBarMoveFeedback.this.getHost().removeTooltipRequester(this);
            super.deactivate();
        }

        private TaskBarFigure getBarFigure() {
            return (TaskBarFigure)TaskBarMoveFeedback.this.getHost().getBarFigure();
        }

        private DateInfo createNewDateInfo(DateInfo oldDate, long deltaMillis, boolean allDay) {
            DateInfo newDate = new DateInfo();
            newDate.date.setTimeInMillis(oldDate.date.getTimeInMillis() + deltaMillis);
            if (allDay) {
                newDate.allDay = oldDate.allDay;
                if (oldDate.allDay) {
                    newDate.setTime(0, 0, 0);
                }
            } else {
                newDate.allDay = false;
            }
            return newDate;
        }

        public Cursor getCurrentCursor(Point pos, IPart host) {
            AbstractDragTracker.Status initStatus = this.getInitStatus();
            if (initStatus != null && initStatus.getBoolean(TaskBarMoveFeedback.MOVING_START, false) && initStatus.getBoolean(TaskBarMoveFeedback.MOVING_END, false)) {
                return Cursors.HAND;
            }
            return Cursors.SIZEWE;
        }

        protected boolean captureInitialStatus(MouseEvent me, AbstractDragTracker.Status initStatus) {
            Point cursorLocation = me.cursorLocation;
            initStatus.set((Object)TaskBarMoveFeedback.LOCATION, cursorLocation.x);
            TaskBarFigure figure = this.getBarFigure();
            initStatus.set((Object)TaskBarMoveFeedback.OFFSET, figure.getOffset());
            initStatus.set((Object)TaskBarMoveFeedback.LENGTH, figure.getLength());
            TaskBar bar = TaskBarMoveFeedback.this.getHost().getTaskBar();
            DateInfo startDate = bar.getStartDate();
            DateInfo endDate = bar.getEndDate();
            initStatus.set((Object)TaskBarMoveFeedback.START_DATE, startDate);
            initStatus.set((Object)TaskBarMoveFeedback.END_DATE, endDate);
            initStatus.set((Object)TaskBarMoveFeedback.MOVING_START, !TaskBarMoveFeedback.this.isOverHandle(cursorLocation, new IFigure[]{TaskBarMoveFeedback.this.rightHandle}));
            initStatus.set((Object)TaskBarMoveFeedback.MOVING_END, !TaskBarMoveFeedback.this.isOverHandle(cursorLocation, new IFigure[]{TaskBarMoveFeedback.this.leftHandle}));
            return true;
        }

        protected Command getCommand(AbstractDragTracker.Status initStatus, AbstractDragTracker.Status status) {
            boolean movingStart = initStatus.getBoolean(TaskBarMoveFeedback.MOVING_START, false);
            boolean movingEnd = initStatus.getBoolean(TaskBarMoveFeedback.MOVING_END, false);
            if (!movingStart && !movingEnd) {
                return null;
            }
            int delta = status.getInteger(TaskBarMoveFeedback.DELTA, 0);
            if (delta == 0) {
                return null;
            }
            DateInfo startDate = (DateInfo)status.get(TaskBarMoveFeedback.START_DATE);
            DateInfo endDate = (DateInfo)status.get(TaskBarMoveFeedback.END_DATE);
            if (startDate == null && endDate == null) {
                return null;
            }
            DurationInfo duration = DurationInfo.calcDuration((DateInfo)startDate, (DateInfo)endDate);
            ITopic task = TaskBarMoveFeedback.this.getHost().getTask();
            ArrayList<Command> commands = new ArrayList<Command>(2);
            TaskInfoUtils.checkDuration((ITopic)task, (boolean)false);
            if (TaskInfoUtils.getStartDateInfo((ITopic)task) != null) {
                if (TaskInfoUtils.getEndDateInfo((ITopic)task) != null) {
                    if (movingStart && !movingEnd) {
                        commands.add(TaskInfoUtils.createChangeStartDateCommand((ITopic)task, (DateInfo)startDate));
                    } else if (!movingStart && movingEnd) {
                        commands.add(TaskInfoUtils.createChangeEndDateCommand((ITopic)task, (DateInfo)endDate));
                    } else {
                        commands.add(TaskInfoUtils.createChangeStartDateCommand((ITopic)task, (DateInfo)startDate));
                        commands.add(TaskInfoUtils.createChangeEndDateCommand((ITopic)task, (DateInfo)endDate));
                    }
                } else if (movingStart && !movingEnd) {
                    commands.add(TaskInfoUtils.createChangeStartDateCommand((ITopic)task, (DateInfo)startDate));
                    commands.add(TaskInfoUtils.createChangeDurationCommand((ITopic)task, (DurationInfo)duration));
                } else if (!movingStart && movingEnd) {
                    commands.add(TaskInfoUtils.createChangeDurationCommand((ITopic)task, (DurationInfo)duration));
                } else {
                    commands.add(TaskInfoUtils.createChangeStartDateCommand((ITopic)task, (DateInfo)startDate));
                }
            } else if (TaskInfoUtils.getEndDateInfo((ITopic)task) != null) {
                if (movingStart && !movingEnd) {
                    commands.add(TaskInfoUtils.createChangeDurationCommand((ITopic)task, (DurationInfo)duration));
                } else if (!movingStart && movingEnd) {
                    commands.add(TaskInfoUtils.createChangeDurationCommand((ITopic)task, (DurationInfo)duration));
                    commands.add(TaskInfoUtils.createChangeEndDateCommand((ITopic)task, (DateInfo)endDate));
                } else {
                    commands.add(TaskInfoUtils.createChangeEndDateCommand((ITopic)task, (DateInfo)endDate));
                }
            }
            return new CompoundCommand(GanttMessages.Command_ChangeDates, commands);
        }

        protected void applyStatus(AbstractDragTracker.Status status) {
            TaskBar bar = TaskBarMoveFeedback.this.getHost().getTaskBar();
            bar.setStartDate((DateInfo)status.get(TaskBarMoveFeedback.START_DATE));
            bar.setEndDate((DateInfo)status.get(TaskBarMoveFeedback.END_DATE));
            TaskBarFigure figure = this.getBarFigure();
            figure.setOffsetValue(status.getInteger(TaskBarMoveFeedback.OFFSET, 0));
            figure.setLength(status.getInteger(TaskBarMoveFeedback.LENGTH, 1));
        }

        protected boolean updateStatus(MouseEvent me, AbstractDragTracker.Status initStatus, AbstractDragTracker.Status status) {
            boolean allDay;
            boolean movingStart = initStatus.getBoolean(TaskBarMoveFeedback.MOVING_START, false);
            boolean movingEnd = initStatus.getBoolean(TaskBarMoveFeedback.MOVING_END, false);
            if (!movingStart && !movingEnd) {
                return false;
            }
            int oldLength = initStatus.getInteger(TaskBarMoveFeedback.LENGTH, 1);
            int delta = this.constrainDelta(me.cursorLocation.x - initStatus.getInteger(TaskBarMoveFeedback.LOCATION, me.cursorLocation.x), movingStart, movingEnd, oldLength);
            status.set((Object)TaskBarMoveFeedback.DELTA, delta);
            if (!movingStart || !movingEnd) {
                status.set((Object)TaskBarMoveFeedback.LENGTH, oldLength + (movingStart ? -delta : delta));
            }
            if (movingStart) {
                status.set((Object)TaskBarMoveFeedback.OFFSET, initStatus.getInteger(TaskBarMoveFeedback.OFFSET, 0) + delta);
            }
            DateInfo oldStartDate = (DateInfo)initStatus.get(TaskBarMoveFeedback.START_DATE);
            DateInfo oldEndDate = (DateInfo)initStatus.get(TaskBarMoveFeedback.END_DATE);
            TimelineModel timeline = TaskBarMoveFeedback.this.getHost().getTimelineModel();
            boolean bl = allDay = timeline.getPrecision() >= 3323.0;
            if (oldStartDate != null || oldEndDate != null) {
                DateInfo end;
                DateInfo start;
                long deltaMillis = timeline.getMillisFromPixels(delta);
                DateInfo dateInfo = start = oldStartDate == null ? oldEndDate : oldStartDate;
                if (movingStart) {
                    status.set((Object)TaskBarMoveFeedback.START_DATE, this.createNewDateInfo(start, deltaMillis, allDay));
                }
                DateInfo dateInfo2 = end = oldEndDate == null ? oldStartDate : oldEndDate;
                if (movingEnd) {
                    status.set((Object)TaskBarMoveFeedback.END_DATE, this.createNewDateInfo(end, deltaMillis, allDay));
                }
            }
            return true;
        }

        private int constrainDelta(int delta, boolean movingStart, boolean movingEnd, int oldLength) {
            if (!movingStart || !movingEnd) {
                if (movingStart) {
                    delta = Math.min(delta, oldLength - 1);
                } else if (movingEnd) {
                    delta = Math.max(delta, 1 - oldLength);
                }
            }
            return delta;
        }
    }
}

