/*
 * Decompiled with CFR 0.152.
 */
package com.evernote.clients;

import com.evernote.clients.NoteStoreClient;
import com.evernote.edam.error.EDAMNotFoundException;
import com.evernote.edam.error.EDAMSystemException;
import com.evernote.edam.error.EDAMUserException;
import com.evernote.edam.type.LinkedNotebook;
import com.evernote.edam.type.Note;
import com.evernote.edam.type.Notebook;
import com.evernote.edam.type.SharedNotebook;
import com.evernote.edam.userstore.AuthenticationResult;
import com.evernote.thrift.TException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedNoteStoreClient {
    private NoteStoreClient mainNoteStoreClient;
    private NoteStoreClient linkedNoteStoreClient;
    private AuthenticationResult authenticationResult;

    LinkedNoteStoreClient(NoteStoreClient mainNoteStoreClient, NoteStoreClient linkedNoteStoreClient, AuthenticationResult authenticationResult) {
        this.mainNoteStoreClient = mainNoteStoreClient;
        this.linkedNoteStoreClient = linkedNoteStoreClient;
        this.authenticationResult = authenticationResult;
    }

    public NoteStoreClient getClient() {
        return this.linkedNoteStoreClient;
    }

    NoteStoreClient getPersonalClient() {
        return this.mainNoteStoreClient;
    }

    AuthenticationResult getAuthenticationResult() {
        return this.authenticationResult;
    }

    String getToken() {
        return this.getAuthenticationResult().getAuthenticationToken();
    }

    public Note createNote(Note note, LinkedNotebook linkedNotebook) throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        SharedNotebook sharedNotebook = this.getClient().getSharedNotebookByAuth();
        note.setNotebookGuid(sharedNotebook.getNotebookGuid());
        return this.getClient().createNote(note);
    }

    public List<LinkedNotebook> listNotebooks() throws EDAMUserException, EDAMSystemException, TException, EDAMNotFoundException {
        return this.getPersonalClient().listLinkedNotebooks();
    }

    public Notebook getCorrespondingNotebook(LinkedNotebook linkedNotebook) throws TException, EDAMUserException, EDAMSystemException, EDAMNotFoundException {
        SharedNotebook sharedNotebook = this.getClient().getSharedNotebookByAuth();
        return this.getClient().getNotebook(sharedNotebook.getNotebookGuid());
    }

    public boolean isNotebookWritable(LinkedNotebook linkedNotebook) throws EDAMUserException, TException, EDAMSystemException, EDAMNotFoundException {
        Notebook notebook = this.getCorrespondingNotebook(linkedNotebook);
        return !notebook.getRestrictions().isNoCreateNotes();
    }
}

