/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.image;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.xmind.gef.draw2d.graphics.ScaledGraphics;
import org.xmind.gef.image.IExportAreaProvider;
import org.xmind.gef.image.ImageExportUtils;

public class FigureImageDescriptor
extends ImageDescriptor {
    private final IFigure[] figures;
    private IExportAreaProvider exportAreaProvider;
    private ImageData data = null;

    public static ImageDescriptor createFromFigure(IFigure figure) {
        return new FigureImageDescriptor(new IFigure[]{figure}, ImageExportUtils.createExportAreaProvider(ImageExportUtils.getBounds(figure)));
    }

    public static ImageDescriptor createFromFigure(IFigure figure, IExportAreaProvider exportAreaProvider) {
        return new FigureImageDescriptor(new IFigure[]{figure}, exportAreaProvider);
    }

    public static ImageDescriptor createFromFigures(IFigure[] figures, IExportAreaProvider exportAreaProvider) {
        return new FigureImageDescriptor(figures, exportAreaProvider);
    }

    protected FigureImageDescriptor(IFigure[] figures, IExportAreaProvider exportAreaProvider) {
        this.figures = figures;
        this.exportAreaProvider = exportAreaProvider;
    }

    public Image createImage(boolean returnMissingImageOnError, Device device) {
        Rectangle exportArea = this.exportAreaProvider.getExportArea();
        Image image = new Image(device, exportArea.width, exportArea.height);
        double scale = this.exportAreaProvider.getScale();
        if (scale == 0.0) {
            return image;
        }
        return this.render(image, returnMissingImageOnError, exportArea, scale);
    }

    private Image render(Image image, boolean returnMissingImageOnError, Rectangle exportArea, double scale) {
        GC gc = new GC((Drawable)image);
        SWTGraphics baseGraphcis = new SWTGraphics(gc);
        baseGraphcis.translate(-exportArea.x, -exportArea.y);
        Object graphics = baseGraphcis;
        ScaledGraphics scaledGraphics = null;
        if (scale > 0.0 && scale != 1.0) {
            if (ScaledGraphics.SCALED_GRAPHICS_ENABLED) {
                scaledGraphics = new ScaledGraphics((Graphics)graphics);
                scaledGraphics.scale(scale);
                graphics = scaledGraphics;
            } else {
                graphics.scale(scale);
            }
        }
        try {
            try {
                graphics.pushState();
                try {
                    int i = 0;
                    while (i < this.figures.length) {
                        IFigure figure = this.figures[i];
                        figure.paint((Graphics)graphics);
                        graphics.restoreState();
                        ++i;
                    }
                }
                finally {
                    graphics.popState();
                }
            }
            catch (Throwable throwable) {
                if (!returnMissingImageOnError) {
                    image.dispose();
                    image = null;
                }
                if (scaledGraphics != null) {
                    scaledGraphics.dispose();
                }
                baseGraphcis.dispose();
                gc.dispose();
            }
        }
        finally {
            if (scaledGraphics != null) {
                scaledGraphics.dispose();
            }
            baseGraphcis.dispose();
            gc.dispose();
        }
        return image;
    }

    public ImageData getImageData() {
        Image tempImage;
        if (this.data == null && (tempImage = this.createImage(false)) != null) {
            this.data = tempImage.getImageData();
            tempImage.dispose();
        }
        return this.data;
    }
}

